# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from infobip_api_client.models.sending_speed_limit import SendingSpeedLimit
from typing import Optional, Set
from typing_extensions import Self


class MessagesApiRequestSchedulingSettings(BaseModel):
    """
    Options for scheduling a message.
    """  # noqa: E501

    bulk_id: Optional[
        Annotated[str, Field(min_length=0, strict=True, max_length=100)]
    ] = Field(
        default=None,
        description="Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request. If not provided, it will be auto-generated and returned in the API response.",
        alias="bulkId",
    )
    send_at: Optional[datetime] = Field(
        default=None,
        description="Date and time when the message is to be sent. Used for scheduled messages. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, and can only be scheduled for no later than 180 days in advance.",
        alias="sendAt",
    )
    sending_speed_limit: Optional[SendingSpeedLimit] = Field(
        default=None, alias="sendingSpeedLimit"
    )
    __properties: ClassVar[List[str]] = ["bulkId", "sendAt", "sendingSpeedLimit"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MessagesApiRequestSchedulingSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of sending_speed_limit
        if self.sending_speed_limit:
            _dict["sendingSpeedLimit"] = self.sending_speed_limit.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MessagesApiRequestSchedulingSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "bulkId": obj.get("bulkId"),
                "sendAt": obj.get("sendAt"),
                "sendingSpeedLimit": (
                    SendingSpeedLimit.from_dict(obj["sendingSpeedLimit"])
                    if obj.get("sendingSpeedLimit") is not None
                    else None
                ),
            }
        )
        return _obj
