# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from importlib import import_module
from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Union
from infobip_api_client.models.messages_api_webhook_event_content_type import (
    MessagesApiWebhookEventContentType,
)
from typing import Optional, Set

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from infobip_api_client.models.messages_api_webhook_event_audio_content import (
        MessagesApiWebhookEventAudioContent,
    )
    from infobip_api_client.models.messages_api_webhook_event_authentication_response_content import (
        MessagesApiWebhookEventAuthenticationResponseContent,
    )
    from infobip_api_client.models.messages_api_webhook_event_button_reply_content import (
        MessagesApiWebhookEventButtonReplyContent,
    )
    from infobip_api_client.models.messages_api_webhook_event_document_content import (
        MessagesApiWebhookEventDocumentContent,
    )
    from infobip_api_client.models.messages_api_webhook_event_file_content import (
        MessagesApiWebhookEventFileContent,
    )
    from infobip_api_client.models.messages_api_webhook_event_flow_response_content import (
        MessagesApiWebhookEventFlowResponseContent,
    )
    from infobip_api_client.models.messages_api_webhook_event_form_content import (
        MessagesApiWebhookEventFormContent,
    )
    from infobip_api_client.models.messages_api_webhook_event_image_content import (
        MessagesApiWebhookEventImageContent,
    )
    from infobip_api_client.models.messages_api_webhook_event_list_reply_content import (
        MessagesApiWebhookEventListReplyContent,
    )
    from infobip_api_client.models.messages_api_webhook_event_location_content import (
        MessagesApiWebhookEventLocationContent,
    )
    from infobip_api_client.models.messages_api_webhook_event_payment_response_content import (
        MessagesApiWebhookEventPaymentResponseContent,
    )
    from infobip_api_client.models.messages_api_webhook_event_reaction_content import (
        MessagesApiWebhookEventReactionContent,
    )
    from infobip_api_client.models.messages_api_webhook_event_subject_content import (
        MessagesApiWebhookEventSubjectContent,
    )
    from infobip_api_client.models.messages_api_webhook_event_text_content import (
        MessagesApiWebhookEventTextContent,
    )
    from infobip_api_client.models.messages_api_webhook_event_url_content import (
        MessagesApiWebhookEventUrlContent,
    )
    from infobip_api_client.models.messages_api_webhook_event_video_content import (
        MessagesApiWebhookEventVideoContent,
    )


class MessagesApiWebhookEventContent(BaseModel):
    """
    Content of the message.
    """  # noqa: E501

    type: MessagesApiWebhookEventContentType
    __properties: ClassVar[List[str]] = ["type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = "type"

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        "AUDIO": "MessagesApiWebhookEventAudioContent",
        "AUTHENTICATION_RESPONSE": "MessagesApiWebhookEventAuthenticationResponseContent",
        "BUTTON_REPLY": "MessagesApiWebhookEventButtonReplyContent",
        "DOCUMENT": "MessagesApiWebhookEventDocumentContent",
        "FILE": "MessagesApiWebhookEventFileContent",
        "FLOW_RESPONSE": "MessagesApiWebhookEventFlowResponseContent",
        "FORM_RESPONSE": "MessagesApiWebhookEventFormContent",
        "IMAGE": "MessagesApiWebhookEventImageContent",
        "LIST_REPLY": "MessagesApiWebhookEventListReplyContent",
        "LOCATION": "MessagesApiWebhookEventLocationContent",
        "PAYMENT_RESPONSE": "MessagesApiWebhookEventPaymentResponseContent",
        "REACTION": "MessagesApiWebhookEventReactionContent",
        "SUBJECT": "MessagesApiWebhookEventSubjectContent",
        "TEXT": "MessagesApiWebhookEventTextContent",
        "URL": "MessagesApiWebhookEventUrlContent",
        "VIDEO": "MessagesApiWebhookEventVideoContent",
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[
        Union[
            MessagesApiWebhookEventAudioContent,
            MessagesApiWebhookEventAuthenticationResponseContent,
            MessagesApiWebhookEventButtonReplyContent,
            MessagesApiWebhookEventDocumentContent,
            MessagesApiWebhookEventFileContent,
            MessagesApiWebhookEventFlowResponseContent,
            MessagesApiWebhookEventFormContent,
            MessagesApiWebhookEventImageContent,
            MessagesApiWebhookEventListReplyContent,
            MessagesApiWebhookEventLocationContent,
            MessagesApiWebhookEventPaymentResponseContent,
            MessagesApiWebhookEventReactionContent,
            MessagesApiWebhookEventSubjectContent,
            MessagesApiWebhookEventTextContent,
            MessagesApiWebhookEventUrlContent,
            MessagesApiWebhookEventVideoContent,
        ]
    ]:
        """Create an instance of MessagesApiWebhookEventContent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[
        Union[
            MessagesApiWebhookEventAudioContent,
            MessagesApiWebhookEventAuthenticationResponseContent,
            MessagesApiWebhookEventButtonReplyContent,
            MessagesApiWebhookEventDocumentContent,
            MessagesApiWebhookEventFileContent,
            MessagesApiWebhookEventFlowResponseContent,
            MessagesApiWebhookEventFormContent,
            MessagesApiWebhookEventImageContent,
            MessagesApiWebhookEventListReplyContent,
            MessagesApiWebhookEventLocationContent,
            MessagesApiWebhookEventPaymentResponseContent,
            MessagesApiWebhookEventReactionContent,
            MessagesApiWebhookEventSubjectContent,
            MessagesApiWebhookEventTextContent,
            MessagesApiWebhookEventUrlContent,
            MessagesApiWebhookEventVideoContent,
        ]
    ]:
        """Create an instance of MessagesApiWebhookEventContent from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type == "MessagesApiWebhookEventAudioContent":
            return import_module(
                "infobip_api_client.models.messages_api_webhook_event_audio_content"
            ).MessagesApiWebhookEventAudioContent.from_dict(obj)
        if object_type == "MessagesApiWebhookEventAuthenticationResponseContent":
            return import_module(
                "infobip_api_client.models.messages_api_webhook_event_authentication_response_content"
            ).MessagesApiWebhookEventAuthenticationResponseContent.from_dict(obj)
        if object_type == "MessagesApiWebhookEventButtonReplyContent":
            return import_module(
                "infobip_api_client.models.messages_api_webhook_event_button_reply_content"
            ).MessagesApiWebhookEventButtonReplyContent.from_dict(obj)
        if object_type == "MessagesApiWebhookEventDocumentContent":
            return import_module(
                "infobip_api_client.models.messages_api_webhook_event_document_content"
            ).MessagesApiWebhookEventDocumentContent.from_dict(obj)
        if object_type == "MessagesApiWebhookEventFileContent":
            return import_module(
                "infobip_api_client.models.messages_api_webhook_event_file_content"
            ).MessagesApiWebhookEventFileContent.from_dict(obj)
        if object_type == "MessagesApiWebhookEventFlowResponseContent":
            return import_module(
                "infobip_api_client.models.messages_api_webhook_event_flow_response_content"
            ).MessagesApiWebhookEventFlowResponseContent.from_dict(obj)
        if object_type == "MessagesApiWebhookEventFormContent":
            return import_module(
                "infobip_api_client.models.messages_api_webhook_event_form_content"
            ).MessagesApiWebhookEventFormContent.from_dict(obj)
        if object_type == "MessagesApiWebhookEventImageContent":
            return import_module(
                "infobip_api_client.models.messages_api_webhook_event_image_content"
            ).MessagesApiWebhookEventImageContent.from_dict(obj)
        if object_type == "MessagesApiWebhookEventListReplyContent":
            return import_module(
                "infobip_api_client.models.messages_api_webhook_event_list_reply_content"
            ).MessagesApiWebhookEventListReplyContent.from_dict(obj)
        if object_type == "MessagesApiWebhookEventLocationContent":
            return import_module(
                "infobip_api_client.models.messages_api_webhook_event_location_content"
            ).MessagesApiWebhookEventLocationContent.from_dict(obj)
        if object_type == "MessagesApiWebhookEventPaymentResponseContent":
            return import_module(
                "infobip_api_client.models.messages_api_webhook_event_payment_response_content"
            ).MessagesApiWebhookEventPaymentResponseContent.from_dict(obj)
        if object_type == "MessagesApiWebhookEventReactionContent":
            return import_module(
                "infobip_api_client.models.messages_api_webhook_event_reaction_content"
            ).MessagesApiWebhookEventReactionContent.from_dict(obj)
        if object_type == "MessagesApiWebhookEventSubjectContent":
            return import_module(
                "infobip_api_client.models.messages_api_webhook_event_subject_content"
            ).MessagesApiWebhookEventSubjectContent.from_dict(obj)
        if object_type == "MessagesApiWebhookEventTextContent":
            return import_module(
                "infobip_api_client.models.messages_api_webhook_event_text_content"
            ).MessagesApiWebhookEventTextContent.from_dict(obj)
        if object_type == "MessagesApiWebhookEventUrlContent":
            return import_module(
                "infobip_api_client.models.messages_api_webhook_event_url_content"
            ).MessagesApiWebhookEventUrlContent.from_dict(obj)
        if object_type == "MessagesApiWebhookEventVideoContent":
            return import_module(
                "infobip_api_client.models.messages_api_webhook_event_video_content"
            ).MessagesApiWebhookEventVideoContent.from_dict(obj)

        raise ValueError(
            "MessagesApiWebhookEventContent failed to lookup discriminator value from "
            + json.dumps(obj)
            + ". Discriminator property name: "
            + cls.__discriminator_property_name
            + ", mapping: "
            + json.dumps(cls.__discriminator_value_class_map)
        )
