# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from infobip_api_client.models.messages_api_webhook_event_form_item import (
    MessagesApiWebhookEventFormItem,
)
from infobip_api_client.models.messages_api_webhook_event_form_selection_type import (
    MessagesApiWebhookEventFormSelectionType,
)
from typing import Optional, Set
from typing_extensions import Self


class MessagesApiWebhookEventFormSelection(BaseModel):
    """
    List of user responses.
    """  # noqa: E501

    type: MessagesApiWebhookEventFormSelectionType
    page_identifier: StrictStr = Field(
        description="Identifier of the form page where the selection was made.",
        alias="pageIdentifier",
    )
    text: StrictStr = Field(description="Text of selection.")
    items: List[MessagesApiWebhookEventFormItem] = Field(
        description="List of selected items or values provided by the user for this form selection."
    )
    __properties: ClassVar[List[str]] = ["type", "pageIdentifier", "text", "items"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MessagesApiWebhookEventFormSelection from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict["items"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MessagesApiWebhookEventFormSelection from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "type": obj.get("type"),
                "pageIdentifier": obj.get("pageIdentifier"),
                "text": obj.get("text"),
                "items": (
                    [
                        MessagesApiWebhookEventFormItem.from_dict(_item)
                        for _item in obj["items"]
                    ]
                    if obj.get("items") is not None
                    else None
                ),
            }
        )
        return _obj
