# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class SmsBinaryContent(BaseModel):
    """
    SmsBinaryContent
    """  # noqa: E501

    data_coding: Optional[StrictInt] = Field(
        default=0,
        description="Binary content data coding. The default value is (`0`) for GSM7. Example: (`8`) for  Unicode data.",
        alias="dataCoding",
    )
    esm_class: Optional[StrictInt] = Field(
        default=0,
        description="“Esm_class” parameter. Indicate special message attributes associated with the SMS. Default value is (`0`).",
        alias="esmClass",
    )
    hex: StrictStr = Field(
        description="Hexadecimal string. This is the representation of your binary data. Two hex digits represent one byte. They should be separated by the space character."
    )
    __properties: ClassVar[List[str]] = ["dataCoding", "esmClass", "hex"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SmsBinaryContent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SmsBinaryContent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "dataCoding": (
                    obj.get("dataCoding") if obj.get("dataCoding") is not None else 0
                ),
                "esmClass": (
                    obj.get("esmClass") if obj.get("esmClass") is not None else 0
                ),
                "hex": obj.get("hex"),
            }
        )
        return _obj
