# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.sms_request_scheduling_settings import (
    SmsRequestSchedulingSettings,
)
from infobip_api_client.models.sms_tracking import SmsTracking
from infobip_api_client.models.url_options import UrlOptions
from typing import Optional, Set
from typing_extensions import Self


class SmsMessageRequestOptions(BaseModel):
    """
    Options applicable to all messages in the request.
    """  # noqa: E501

    schedule: Optional[SmsRequestSchedulingSettings] = None
    tracking: Optional[UrlOptions] = None
    include_sms_count_in_response: Optional[StrictBool] = Field(
        default=False,
        description="Set to true to return `messageCount` in the response. The `messageCount` is the total count of SMS submitted in the request. SMS messages have a character limit and messages longer than the limit will be split into multiple SMS. Not compatible with `binary` message content type.",
        alias="includeSmsCountInResponse",
    )
    conversion_tracking: Optional[SmsTracking] = Field(
        default=None, alias="conversionTracking"
    )
    __properties: ClassVar[List[str]] = [
        "schedule",
        "tracking",
        "includeSmsCountInResponse",
        "conversionTracking",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SmsMessageRequestOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of schedule
        if self.schedule:
            _dict["schedule"] = self.schedule.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tracking
        if self.tracking:
            _dict["tracking"] = self.tracking.to_dict()
        # override the default output from pydantic by calling `to_dict()` of conversion_tracking
        if self.conversion_tracking:
            _dict["conversionTracking"] = self.conversion_tracking.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SmsMessageRequestOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "schedule": (
                    SmsRequestSchedulingSettings.from_dict(obj["schedule"])
                    if obj.get("schedule") is not None
                    else None
                ),
                "tracking": (
                    UrlOptions.from_dict(obj["tracking"])
                    if obj.get("tracking") is not None
                    else None
                ),
                "includeSmsCountInResponse": (
                    obj.get("includeSmsCountInResponse")
                    if obj.get("includeSmsCountInResponse") is not None
                    else False
                ),
                "conversionTracking": (
                    SmsTracking.from_dict(obj["conversionTracking"])
                    if obj.get("conversionTracking") is not None
                    else None
                ),
            }
        )
        return _obj
