# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from infobip_api_client.models.message_price import MessagePrice
from infobip_api_client.models.viber_inbound_content import ViberInboundContent
from typing import Optional, Set
from typing_extensions import Self


class ViberInboundMessageViberInboundContent(BaseModel):
    """
    Collection of mobile originated messages.
    """  # noqa: E501

    entity_id: Optional[
        Annotated[str, Field(min_length=0, strict=True, max_length=255)]
    ] = Field(
        default=None,
        description="Used when specifying an entity in outbound send requests. It is also returned in notification events. For detailed usage, refer to the [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).",
        alias="entityId",
    )
    application_id: Optional[
        Annotated[str, Field(min_length=0, strict=True, max_length=255)]
    ] = Field(
        default=None,
        description="Used when specifying an entity in outbound send requests. It is also returned in notification events. For detailed usage, refer to the [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).",
        alias="applicationId",
    )
    sender: StrictStr = Field(description="Number which sent the message.")
    to: StrictStr = Field(description="Sender provided during the activation process.")
    integration_type: StrictStr = Field(
        description="Integration type.", alias="integrationType"
    )
    received_at: datetime = Field(
        description="Date and time when Infobip received the message. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSZ.",
        alias="receivedAt",
    )
    keyword: Optional[StrictStr] = Field(
        default=None, description="Keyword extracted from the message text."
    )
    message_id: StrictStr = Field(
        description="The ID that uniquely identifies the received message.",
        alias="messageId",
    )
    paired_message_id: Optional[StrictStr] = Field(
        default=None,
        description="Message ID of paired outgoing message if matched by Infobip platform.",
        alias="pairedMessageId",
    )
    callback_data: Optional[StrictStr] = Field(
        default=None,
        description="Callback data sent through ‛callbackData‛ field when sending message.",
        alias="callbackData",
    )
    message: ViberInboundContent
    price: MessagePrice
    __properties: ClassVar[List[str]] = [
        "entityId",
        "applicationId",
        "sender",
        "to",
        "integrationType",
        "receivedAt",
        "keyword",
        "messageId",
        "pairedMessageId",
        "callbackData",
        "message",
        "price",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ViberInboundMessageViberInboundContent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of message
        if self.message:
            _dict["message"] = self.message.to_dict()
        # override the default output from pydantic by calling `to_dict()` of price
        if self.price:
            _dict["price"] = self.price.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ViberInboundMessageViberInboundContent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "entityId": obj.get("entityId"),
                "applicationId": obj.get("applicationId"),
                "sender": obj.get("sender"),
                "to": obj.get("to"),
                "integrationType": obj.get("integrationType"),
                "receivedAt": obj.get("receivedAt"),
                "keyword": obj.get("keyword"),
                "messageId": obj.get("messageId"),
                "pairedMessageId": obj.get("pairedMessageId"),
                "callbackData": obj.get("callbackData"),
                "message": (
                    ViberInboundContent.from_dict(obj["message"])
                    if obj.get("message") is not None
                    else None
                ),
                "price": (
                    MessagePrice.from_dict(obj["price"])
                    if obj.get("price") is not None
                    else None
                ),
            }
        )
        return _obj
