# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from infobip_api_client.models.viber_button import ViberButton
from infobip_api_client.models.viber_outbound_content import ViberOutboundContent
from infobip_api_client.models.viber_outbound_content_type import (
    ViberOutboundContentType,
)
from typing import Optional, Set
from typing_extensions import Self


class ViberOutboundTextContent(ViberOutboundContent):
    """
    ViberOutboundTextContent
    """  # noqa: E501

    text: Annotated[str, Field(min_length=0, strict=True, max_length=1000)] = Field(
        description="Content of the message being sent. If sending a template, see the [guidance and compliance rules](https://www.infobip.com/docs/viber/business-messages/api#message-template-business-messages-api)."
    )
    button: Optional[ViberButton] = None
    type: ViberOutboundContentType = "TEXT"
    __properties: ClassVar[List[str]] = ["type", "text", "button"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ViberOutboundTextContent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of button
        if self.button:
            _dict["button"] = self.button.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ViberOutboundTextContent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "type": obj.get("type"),
                "text": obj.get("text"),
                "button": (
                    ViberButton.from_dict(obj["button"])
                    if obj.get("button") is not None
                    else None
                ),
            }
        )
        return _obj
