"""InnerLoop SDK public API.

Re-exports the modern Loop API and common configuration models.
"""

from .errors import (  # noqa: F401
    CliExitError,
    CliNotFoundError,
    CliTimeoutError,
    ModelNotFoundError,
    InnerLoopError,
)
from .mcp import (  # noqa: F401
    LocalMcpServer,
    RemoteMcpServer,
)
from .permissions import Permission  # noqa: F401
from .providers import (  # noqa: F401
    AnthropicProvider,
    LMStudioProvider,
    OllamaProvider,
    OpenAIProvider,
)
from .response import Response  # noqa: F401
from .api import (
    Loop,
    run,
    arun,
    iterate_events,
    allow,
    mcp,
)  # noqa: F401
from .logging_config import (  # noqa: F401
    configure_logging,
    disable_logging,
)

__all__ = [
    "Permission",
    "Response",
    "InnerLoopError",
    "CliExitError",
    "CliNotFoundError",
    "CliTimeoutError",
    "ModelNotFoundError",
    # Typed configuration exports
    "OpenAIProvider",
    "AnthropicProvider",
    "OllamaProvider",
    "LMStudioProvider",
    "LocalMcpServer",
    "RemoteMcpServer",
    # New functional API
    "Loop",
    "run",
    "arun",
    "iterate_events",
    "allow",
    "mcp",
    # Logging configuration
    "configure_logging",
    "disable_logging",
]
