"""InnerLoop SDK public API.

Re-exports the modern Loop API and common configuration models.
"""

from .errors import (  # noqa: F401
    CliExitError,
    CliNotFoundError,
    CliTimeoutError,
    ModelNotFoundError,
    InnerLoopError,
)
from .mcp import (  # noqa: F401
    LocalMcpServer,
    RemoteMcpServer,
)
from .permissions import Permission  # noqa: F401
from .providers import (  # noqa: F401
    AnthropicProvider,
    LMStudioProvider,
    OllamaProvider,
    OpenAIProvider,
)
from .response import Response  # noqa: F401
from .api import (
    Loop,
    run,
    arun,
    stream,
    astream,
    allow,
    mcp,
)  # noqa: F401
from .logging_config import (  # noqa: F401
    configure_logging,
    disable_logging,
)
from .tools import (  # noqa: F401
    tool,
    list_tools,
    get_tool,
)
from .skills import (  # noqa: F401
    Skill,
)

__all__ = [
    "Permission",
    "Response",
    "InnerLoopError",
    "CliExitError",
    "CliNotFoundError",
    "CliTimeoutError",
    "ModelNotFoundError",
    # Typed configuration exports
    "OpenAIProvider",
    "AnthropicProvider",
    "OllamaProvider",
    "LMStudioProvider",
    "LocalMcpServer",
    "RemoteMcpServer",
    # New functional API
    "Loop",
    "run",
    "arun",
    "stream",
    "astream",
    "allow",
    "mcp",
    # Logging configuration
    "configure_logging",
    "disable_logging",
    # Tools API
    "tool",
    "list_tools",
    "get_tool",
    # Skills API
    "Skill",
]
