# coding: utf-8

"""
    Insights Service API -test

    ## Introduction  Swaggerâ¢ is a project used to describe and document RESTful APIs. This section provides an overview of the API design, methods, and supported use cases.    Most of the endpoints accept **JSON** as input and return **JSON** responses.  ```  Content-type: application/json   Accept: application/json  ```  ## Resources  A resource in Swagger is an entity that has a set of exposed operations. The entity can represent an actual object (account, users..) or a set of logical operations collated together. It is up to the specification user to decide whether sub-resources should be referred to as part of their main resource or as a resource of their own. For example, assume the following URL set:     ```    /users         -GET                   POST                    /users/{id}    -GET                   PATCH                   DELETE   ```    ## CRUD Operations  The platform supports Create, Read, Update, and Delete operations on most resources. You can review the standards for these operations and their standard parameters below.    Some endpoints have special behavior as exceptions.    ### Create  To create a resource, you typically submit an HTTP POST request with the resource's required metadata in the request body. The response returns a 201 Created response code upon success with the resource's metadata, including its internal id, in the response body.    ### Read  The HTTP GET request can be used to read a resource or to list a number of resources.    A resource's id can be submitted in the request parameters to read a specific resource. The response usually returns a 200 OK response code upon success, with the resource's metadata in the response body.    If a GET request does not include a specific resource id, it is treated as a list request. The response usually returns a 200 OK response code upon success, with an object containing a list of resources' metadata in the response body.    When reading resources, some common query parameters are usually available. e.g. :  ```  v1/users?size=25&page=1  ```  **Query Parameter Type Description**  - size should be between 10 and 300 (default value 50)    - page should be a zero or any positive number (default value 0)    ### Update  Updating a resource requires the resource id, and is typically done using an HTTP PATCH request, with the fields to modify in the request body. The response usually returns a 200 OK response code upon success, with information about the modified resource in the response body.    ### Delete  Deleting a resource requires the resource id and is typically executing via an HTTP DELETE request. The response usually returns a 204 No Content response code upon success.    ## Trying the API  You can use [Swagger UI](https://swagger.io/tools/swagger-ui/) or any third party client such as ,[Postman](https://www.postman.com/), [cURL](https://curl.se/) etc. to test the REST API.    **Swagger UI**    - Authorize API by clicking on **Authorize** button.   - Select an API resource  - Click on **Try it out**   - filterQuery (Parameters): If required add parameters else keep blank json  ```   e.g.   {           \"size\": 300,           \"page\": 0,          }             e.g.   {          }            ```              - Fill the headers like TenantType, OrgId & X-Api-Key   - Click on **Execute**    **Curl**  ```  curl -X 'GET' \\  'http://localhost:8085/api/v1/crops' \\  -H 'accept: application/json' \\  -H 'TenantType: SMARTRISK' \\  -H 'orgId: test' \\  -H 'X-Api-Key: qwjokooopppp' \\  -H 'Authorization: Bearer jklkopalkddlplplllllllllll2340k'  ```  Using a graphical tool such as Postman, it is possible to import the API specifications directly:    - Download the API specification by clicking the **Download** button at top of this document  - Import the JSON specification in the graphical tool of your choice.  - In *Postman*, you can click the import button at the top    ## Enabling CORS  [Cross-origin resource sharing (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) is a browser security feature that restricts HTTP requests that are initiated from scripts running in the browser.      ## Authentication  The API authentication process validates the identity of the client attempting to make a connection by using an authentication protocol. REST API support many authentication methods which are as follows :    **HTTP Authentication Schemes**:    - Basic  - Bearer  - Digest  - OAuth and others...    Insights Service uses Bearer Authentication (also called token authentication) is an HTTP authentication scheme that involves security tokens called bearer tokens.    **Access Token** can be generated by following API by passing valid request payload (see Authenticate API)  ```  POST   /api/v1/authenticate  ```    For more details on authentication, see [API Authentication](https://www.3pillarglobal.com/insights/most-popular-api-authentication-methods).    ## Errors  The REST API reports errors by returning an appropriate HTTP response code, for example 404 (Not Found), and a JSON response. Any HTTP response code that is not in the range 200 - 299 is considered an error.    ### BadRequest (400)  This response means that the server cannot or will not process the request due to something that is perceived to be a client error (e.g., malformed request syntax, invalid request message framing, or deceptive request routing). To resolve this, please ensure that your syntax is correct.  ### Unauthorized (401)  Indicates that the request requires user authentication information. The client may repeat the request with a suitable Authorization header field.    ### Forbidden (403)  Unauthorized request. The client does not have access rights to the content. Unlike 401, the clientâs identity is known to the server.    ### NotFound (404)  The server can not find the requested resource.    ### MethodNotAllowed (405)  The request HTTP method is known by the server but has been disabled and cannot be used for that resource.  ### NotAcceptable (406)  The server does not find any content that conforms to the criteria given by the user agent in header sent in the request.  ### AlreadyExists  The request could not be completed due to a conflict with the current state of the target resource, e.g. the resource it tries to create already exists.  ### Internal Server Error (500)  The server encountered an unexpected condition that prevented it from fulfilling the request.    For more details on HTTP Status code see [HTTP Status Codes](https://restfulapi.net/http-status-codes/)   # noqa: E501

    OpenAPI spec version: v1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class BoundaryMetrics(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cloud_coverage': 'float',
        'ndvi': 'float',
        'savi': 'float',
        'evi': 'float',
        'chire': 'float',
        'ndre': 'float',
        'arvi': 'float',
        'lswi': 'float',
        'lai1': 'float',
        'lai2': 'float',
        'rgi_low': 'float',
        'rgi_medium': 'float',
        'rgi_high': 'float',
        'vis': 'float',
        'category': 'str'
    }

    attribute_map = {
        'cloud_coverage': 'cloudCoverage',
        'ndvi': 'ndvi',
        'savi': 'savi',
        'evi': 'evi',
        'chire': 'chire',
        'ndre': 'ndre',
        'arvi': 'arvi',
        'lswi': 'lswi',
        'lai1': 'lai1',
        'lai2': 'lai2',
        'rgi_low': 'rgiLow',
        'rgi_medium': 'rgiMedium',
        'rgi_high': 'rgiHigh',
        'vis': 'vis',
        'category': 'category'
    }

    def __init__(self, cloud_coverage=None, ndvi=None, savi=None, evi=None, chire=None, ndre=None, arvi=None, lswi=None, lai1=None, lai2=None, rgi_low=None, rgi_medium=None, rgi_high=None, vis=None, category=None):  # noqa: E501
        """BoundaryMetrics - a model defined in Swagger"""  # noqa: E501
        self._cloud_coverage = None
        self._ndvi = None
        self._savi = None
        self._evi = None
        self._chire = None
        self._ndre = None
        self._arvi = None
        self._lswi = None
        self._lai1 = None
        self._lai2 = None
        self._rgi_low = None
        self._rgi_medium = None
        self._rgi_high = None
        self._vis = None
        self._category = None
        self.discriminator = None
        if cloud_coverage is not None:
            self.cloud_coverage = cloud_coverage
        if ndvi is not None:
            self.ndvi = ndvi
        if savi is not None:
            self.savi = savi
        if evi is not None:
            self.evi = evi
        if chire is not None:
            self.chire = chire
        if ndre is not None:
            self.ndre = ndre
        if arvi is not None:
            self.arvi = arvi
        if lswi is not None:
            self.lswi = lswi
        if lai1 is not None:
            self.lai1 = lai1
        if lai2 is not None:
            self.lai2 = lai2
        if rgi_low is not None:
            self.rgi_low = rgi_low
        if rgi_medium is not None:
            self.rgi_medium = rgi_medium
        if rgi_high is not None:
            self.rgi_high = rgi_high
        if vis is not None:
            self.vis = vis
        if category is not None:
            self.category = category

    @property
    def cloud_coverage(self):
        """Gets the cloud_coverage of this BoundaryMetrics.  # noqa: E501


        :return: The cloud_coverage of this BoundaryMetrics.  # noqa: E501
        :rtype: float
        """
        return self._cloud_coverage

    @cloud_coverage.setter
    def cloud_coverage(self, cloud_coverage):
        """Sets the cloud_coverage of this BoundaryMetrics.


        :param cloud_coverage: The cloud_coverage of this BoundaryMetrics.  # noqa: E501
        :type: float
        """

        self._cloud_coverage = cloud_coverage

    @property
    def ndvi(self):
        """Gets the ndvi of this BoundaryMetrics.  # noqa: E501


        :return: The ndvi of this BoundaryMetrics.  # noqa: E501
        :rtype: float
        """
        return self._ndvi

    @ndvi.setter
    def ndvi(self, ndvi):
        """Sets the ndvi of this BoundaryMetrics.


        :param ndvi: The ndvi of this BoundaryMetrics.  # noqa: E501
        :type: float
        """

        self._ndvi = ndvi

    @property
    def savi(self):
        """Gets the savi of this BoundaryMetrics.  # noqa: E501


        :return: The savi of this BoundaryMetrics.  # noqa: E501
        :rtype: float
        """
        return self._savi

    @savi.setter
    def savi(self, savi):
        """Sets the savi of this BoundaryMetrics.


        :param savi: The savi of this BoundaryMetrics.  # noqa: E501
        :type: float
        """

        self._savi = savi

    @property
    def evi(self):
        """Gets the evi of this BoundaryMetrics.  # noqa: E501


        :return: The evi of this BoundaryMetrics.  # noqa: E501
        :rtype: float
        """
        return self._evi

    @evi.setter
    def evi(self, evi):
        """Sets the evi of this BoundaryMetrics.


        :param evi: The evi of this BoundaryMetrics.  # noqa: E501
        :type: float
        """

        self._evi = evi

    @property
    def chire(self):
        """Gets the chire of this BoundaryMetrics.  # noqa: E501


        :return: The chire of this BoundaryMetrics.  # noqa: E501
        :rtype: float
        """
        return self._chire

    @chire.setter
    def chire(self, chire):
        """Sets the chire of this BoundaryMetrics.


        :param chire: The chire of this BoundaryMetrics.  # noqa: E501
        :type: float
        """

        self._chire = chire

    @property
    def ndre(self):
        """Gets the ndre of this BoundaryMetrics.  # noqa: E501


        :return: The ndre of this BoundaryMetrics.  # noqa: E501
        :rtype: float
        """
        return self._ndre

    @ndre.setter
    def ndre(self, ndre):
        """Sets the ndre of this BoundaryMetrics.


        :param ndre: The ndre of this BoundaryMetrics.  # noqa: E501
        :type: float
        """

        self._ndre = ndre

    @property
    def arvi(self):
        """Gets the arvi of this BoundaryMetrics.  # noqa: E501


        :return: The arvi of this BoundaryMetrics.  # noqa: E501
        :rtype: float
        """
        return self._arvi

    @arvi.setter
    def arvi(self, arvi):
        """Sets the arvi of this BoundaryMetrics.


        :param arvi: The arvi of this BoundaryMetrics.  # noqa: E501
        :type: float
        """

        self._arvi = arvi

    @property
    def lswi(self):
        """Gets the lswi of this BoundaryMetrics.  # noqa: E501


        :return: The lswi of this BoundaryMetrics.  # noqa: E501
        :rtype: float
        """
        return self._lswi

    @lswi.setter
    def lswi(self, lswi):
        """Sets the lswi of this BoundaryMetrics.


        :param lswi: The lswi of this BoundaryMetrics.  # noqa: E501
        :type: float
        """

        self._lswi = lswi

    @property
    def lai1(self):
        """Gets the lai1 of this BoundaryMetrics.  # noqa: E501


        :return: The lai1 of this BoundaryMetrics.  # noqa: E501
        :rtype: float
        """
        return self._lai1

    @lai1.setter
    def lai1(self, lai1):
        """Sets the lai1 of this BoundaryMetrics.


        :param lai1: The lai1 of this BoundaryMetrics.  # noqa: E501
        :type: float
        """

        self._lai1 = lai1

    @property
    def lai2(self):
        """Gets the lai2 of this BoundaryMetrics.  # noqa: E501


        :return: The lai2 of this BoundaryMetrics.  # noqa: E501
        :rtype: float
        """
        return self._lai2

    @lai2.setter
    def lai2(self, lai2):
        """Sets the lai2 of this BoundaryMetrics.


        :param lai2: The lai2 of this BoundaryMetrics.  # noqa: E501
        :type: float
        """

        self._lai2 = lai2

    @property
    def rgi_low(self):
        """Gets the rgi_low of this BoundaryMetrics.  # noqa: E501


        :return: The rgi_low of this BoundaryMetrics.  # noqa: E501
        :rtype: float
        """
        return self._rgi_low

    @rgi_low.setter
    def rgi_low(self, rgi_low):
        """Sets the rgi_low of this BoundaryMetrics.


        :param rgi_low: The rgi_low of this BoundaryMetrics.  # noqa: E501
        :type: float
        """

        self._rgi_low = rgi_low

    @property
    def rgi_medium(self):
        """Gets the rgi_medium of this BoundaryMetrics.  # noqa: E501


        :return: The rgi_medium of this BoundaryMetrics.  # noqa: E501
        :rtype: float
        """
        return self._rgi_medium

    @rgi_medium.setter
    def rgi_medium(self, rgi_medium):
        """Sets the rgi_medium of this BoundaryMetrics.


        :param rgi_medium: The rgi_medium of this BoundaryMetrics.  # noqa: E501
        :type: float
        """

        self._rgi_medium = rgi_medium

    @property
    def rgi_high(self):
        """Gets the rgi_high of this BoundaryMetrics.  # noqa: E501


        :return: The rgi_high of this BoundaryMetrics.  # noqa: E501
        :rtype: float
        """
        return self._rgi_high

    @rgi_high.setter
    def rgi_high(self, rgi_high):
        """Sets the rgi_high of this BoundaryMetrics.


        :param rgi_high: The rgi_high of this BoundaryMetrics.  # noqa: E501
        :type: float
        """

        self._rgi_high = rgi_high

    @property
    def vis(self):
        """Gets the vis of this BoundaryMetrics.  # noqa: E501


        :return: The vis of this BoundaryMetrics.  # noqa: E501
        :rtype: float
        """
        return self._vis

    @vis.setter
    def vis(self, vis):
        """Sets the vis of this BoundaryMetrics.


        :param vis: The vis of this BoundaryMetrics.  # noqa: E501
        :type: float
        """

        self._vis = vis

    @property
    def category(self):
        """Gets the category of this BoundaryMetrics.  # noqa: E501


        :return: The category of this BoundaryMetrics.  # noqa: E501
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this BoundaryMetrics.


        :param category: The category of this BoundaryMetrics.  # noqa: E501
        :type: str
        """
        allowed_values = ["CMK", "PARTIAL", "COMPLETE", "ALL_DARK_PIXELS"]  # noqa: E501
        if category not in allowed_values:
            raise ValueError(
                "Invalid value for `category` ({0}), must be one of {1}"  # noqa: E501
                .format(category, allowed_values)
            )

        self._category = category

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(BoundaryMetrics, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BoundaryMetrics):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
