# coding: utf-8

"""
    Insights Service API -test

    ## Introduction  Swaggerâ¢ is a project used to describe and document RESTful APIs. This section provides an overview of the API design, methods, and supported use cases.    Most of the endpoints accept **JSON** as input and return **JSON** responses.  ```  Content-type: application/json   Accept: application/json  ```  ## Resources  A resource in Swagger is an entity that has a set of exposed operations. The entity can represent an actual object (account, users..) or a set of logical operations collated together. It is up to the specification user to decide whether sub-resources should be referred to as part of their main resource or as a resource of their own. For example, assume the following URL set:     ```    /users         -GET                   POST                    /users/{id}    -GET                   PATCH                   DELETE   ```    ## CRUD Operations  The platform supports Create, Read, Update, and Delete operations on most resources. You can review the standards for these operations and their standard parameters below.    Some endpoints have special behavior as exceptions.    ### Create  To create a resource, you typically submit an HTTP POST request with the resource's required metadata in the request body. The response returns a 201 Created response code upon success with the resource's metadata, including its internal id, in the response body.    ### Read  The HTTP GET request can be used to read a resource or to list a number of resources.    A resource's id can be submitted in the request parameters to read a specific resource. The response usually returns a 200 OK response code upon success, with the resource's metadata in the response body.    If a GET request does not include a specific resource id, it is treated as a list request. The response usually returns a 200 OK response code upon success, with an object containing a list of resources' metadata in the response body.    When reading resources, some common query parameters are usually available. e.g. :  ```  v1/users?size=25&page=1  ```  **Query Parameter Type Description**  - size should be between 10 and 300 (default value 50)    - page should be a zero or any positive number (default value 0)    ### Update  Updating a resource requires the resource id, and is typically done using an HTTP PATCH request, with the fields to modify in the request body. The response usually returns a 200 OK response code upon success, with information about the modified resource in the response body.    ### Delete  Deleting a resource requires the resource id and is typically executing via an HTTP DELETE request. The response usually returns a 204 No Content response code upon success.    ## Trying the API  You can use [Swagger UI](https://swagger.io/tools/swagger-ui/) or any third party client such as ,[Postman](https://www.postman.com/), [cURL](https://curl.se/) etc. to test the REST API.    **Swagger UI**    - Authorize API by clicking on **Authorize** button.   - Select an API resource  - Click on **Try it out**   - filterQuery (Parameters): If required add parameters else keep blank json  ```   e.g.   {           \"size\": 300,           \"page\": 0,          }             e.g.   {          }            ```              - Fill the headers like TenantType, OrgId & X-Api-Key   - Click on **Execute**    **Curl**  ```  curl -X 'GET' \\  'http://localhost:8085/api/v1/crops' \\  -H 'accept: application/json' \\  -H 'TenantType: SMARTRISK' \\  -H 'orgId: test' \\  -H 'X-Api-Key: qwjokooopppp' \\  -H 'Authorization: Bearer jklkopalkddlplplllllllllll2340k'  ```  Using a graphical tool such as Postman, it is possible to import the API specifications directly:    - Download the API specification by clicking the **Download** button at top of this document  - Import the JSON specification in the graphical tool of your choice.  - In *Postman*, you can click the import button at the top    ## Enabling CORS  [Cross-origin resource sharing (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) is a browser security feature that restricts HTTP requests that are initiated from scripts running in the browser.      ## Authentication  The API authentication process validates the identity of the client attempting to make a connection by using an authentication protocol. REST API support many authentication methods which are as follows :    **HTTP Authentication Schemes**:    - Basic  - Bearer  - Digest  - OAuth and others...    Insights Service uses Bearer Authentication (also called token authentication) is an HTTP authentication scheme that involves security tokens called bearer tokens.    **Access Token** can be generated by following API by passing valid request payload (see Authenticate API)  ```  POST   /api/v1/authenticate  ```    For more details on authentication, see [API Authentication](https://www.3pillarglobal.com/insights/most-popular-api-authentication-methods).    ## Errors  The REST API reports errors by returning an appropriate HTTP response code, for example 404 (Not Found), and a JSON response. Any HTTP response code that is not in the range 200 - 299 is considered an error.    ### BadRequest (400)  This response means that the server cannot or will not process the request due to something that is perceived to be a client error (e.g., malformed request syntax, invalid request message framing, or deceptive request routing). To resolve this, please ensure that your syntax is correct.  ### Unauthorized (401)  Indicates that the request requires user authentication information. The client may repeat the request with a suitable Authorization header field.    ### Forbidden (403)  Unauthorized request. The client does not have access rights to the content. Unlike 401, the clientâs identity is known to the server.    ### NotFound (404)  The server can not find the requested resource.    ### MethodNotAllowed (405)  The request HTTP method is known by the server but has been disabled and cannot be used for that resource.  ### NotAcceptable (406)  The server does not find any content that conforms to the criteria given by the user agent in header sent in the request.  ### AlreadyExists  The request could not be completed due to a conflict with the current state of the target resource, e.g. the resource it tries to create already exists.  ### Internal Server Error (500)  The server encountered an unexpected condition that prevented it from fulfilling the request.    For more details on HTTP Status code see [HTTP Status Codes](https://restfulapi.net/http-status-codes/)   # noqa: E501

    OpenAPI spec version: v1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class BoundaryResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'created_date_time': 'datetime',
        'modified_date_time': 'datetime',
        'status': 'str',
        'properties': 'dict(str, object)',
        'parent_ids': 'list[str]',
        'tenant_type': 'str',
        'org_id': 'str',
        'name': 'str',
        'type': 'str',
        'current_level': 'str',
        'geohash': 'str',
        'area_in_hectares': 'float',
        'external_id': 'str',
        'tile_details': 'dict(str, list[str])',
        'geo_hierarchy': 'list[dict(str, str)]',
        'crop_details': 'list[CropDetail]'
    }

    attribute_map = {
        'id': 'id',
        'created_date_time': 'createdDateTime',
        'modified_date_time': 'modifiedDateTime',
        'status': 'status',
        'properties': 'properties',
        'parent_ids': 'parentIds',
        'tenant_type': 'tenantType',
        'org_id': 'orgId',
        'name': 'name',
        'type': 'type',
        'current_level': 'currentLevel',
        'geohash': 'geohash',
        'area_in_hectares': 'areaInHectares',
        'external_id': 'externalId',
        'tile_details': 'tileDetails',
        'geo_hierarchy': 'geoHierarchy',
        'crop_details': 'cropDetails'
    }

    def __init__(self, id=None, created_date_time=None, modified_date_time=None, status=None, properties=None, parent_ids=None, tenant_type=None, org_id=None, name=None, type=None, current_level=None, geohash=None, area_in_hectares=None, external_id=None, tile_details=None, geo_hierarchy=None, crop_details=None):  # noqa: E501
        """BoundaryResponse - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._created_date_time = None
        self._modified_date_time = None
        self._status = None
        self._properties = None
        self._parent_ids = None
        self._tenant_type = None
        self._org_id = None
        self._name = None
        self._type = None
        self._current_level = None
        self._geohash = None
        self._area_in_hectares = None
        self._external_id = None
        self._tile_details = None
        self._geo_hierarchy = None
        self._crop_details = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if created_date_time is not None:
            self.created_date_time = created_date_time
        if modified_date_time is not None:
            self.modified_date_time = modified_date_time
        if status is not None:
            self.status = status
        if properties is not None:
            self.properties = properties
        if parent_ids is not None:
            self.parent_ids = parent_ids
        if tenant_type is not None:
            self.tenant_type = tenant_type
        if org_id is not None:
            self.org_id = org_id
        if name is not None:
            self.name = name
        if type is not None:
            self.type = type
        if current_level is not None:
            self.current_level = current_level
        if geohash is not None:
            self.geohash = geohash
        if area_in_hectares is not None:
            self.area_in_hectares = area_in_hectares
        if external_id is not None:
            self.external_id = external_id
        if tile_details is not None:
            self.tile_details = tile_details
        if geo_hierarchy is not None:
            self.geo_hierarchy = geo_hierarchy
        if crop_details is not None:
            self.crop_details = crop_details

    @property
    def id(self):
        """Gets the id of this BoundaryResponse.  # noqa: E501


        :return: The id of this BoundaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BoundaryResponse.


        :param id: The id of this BoundaryResponse.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def created_date_time(self):
        """Gets the created_date_time of this BoundaryResponse.  # noqa: E501


        :return: The created_date_time of this BoundaryResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._created_date_time

    @created_date_time.setter
    def created_date_time(self, created_date_time):
        """Sets the created_date_time of this BoundaryResponse.


        :param created_date_time: The created_date_time of this BoundaryResponse.  # noqa: E501
        :type: datetime
        """

        self._created_date_time = created_date_time

    @property
    def modified_date_time(self):
        """Gets the modified_date_time of this BoundaryResponse.  # noqa: E501


        :return: The modified_date_time of this BoundaryResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._modified_date_time

    @modified_date_time.setter
    def modified_date_time(self, modified_date_time):
        """Sets the modified_date_time of this BoundaryResponse.


        :param modified_date_time: The modified_date_time of this BoundaryResponse.  # noqa: E501
        :type: datetime
        """

        self._modified_date_time = modified_date_time

    @property
    def status(self):
        """Gets the status of this BoundaryResponse.  # noqa: E501


        :return: The status of this BoundaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this BoundaryResponse.


        :param status: The status of this BoundaryResponse.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def properties(self):
        """Gets the properties of this BoundaryResponse.  # noqa: E501


        :return: The properties of this BoundaryResponse.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """Sets the properties of this BoundaryResponse.


        :param properties: The properties of this BoundaryResponse.  # noqa: E501
        :type: dict(str, object)
        """

        self._properties = properties

    @property
    def parent_ids(self):
        """Gets the parent_ids of this BoundaryResponse.  # noqa: E501


        :return: The parent_ids of this BoundaryResponse.  # noqa: E501
        :rtype: list[str]
        """
        return self._parent_ids

    @parent_ids.setter
    def parent_ids(self, parent_ids):
        """Sets the parent_ids of this BoundaryResponse.


        :param parent_ids: The parent_ids of this BoundaryResponse.  # noqa: E501
        :type: list[str]
        """

        self._parent_ids = parent_ids

    @property
    def tenant_type(self):
        """Gets the tenant_type of this BoundaryResponse.  # noqa: E501


        :return: The tenant_type of this BoundaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._tenant_type

    @tenant_type.setter
    def tenant_type(self, tenant_type):
        """Sets the tenant_type of this BoundaryResponse.


        :param tenant_type: The tenant_type of this BoundaryResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["SMARTFARM", "SMARTFARM_PLUS", "SMARTRISK", "API_USER", "SF_PLUS_API"]  # noqa: E501
        if tenant_type not in allowed_values:
            raise ValueError(
                "Invalid value for `tenant_type` ({0}), must be one of {1}"  # noqa: E501
                .format(tenant_type, allowed_values)
            )

        self._tenant_type = tenant_type

    @property
    def org_id(self):
        """Gets the org_id of this BoundaryResponse.  # noqa: E501


        :return: The org_id of this BoundaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._org_id

    @org_id.setter
    def org_id(self, org_id):
        """Sets the org_id of this BoundaryResponse.


        :param org_id: The org_id of this BoundaryResponse.  # noqa: E501
        :type: str
        """

        self._org_id = org_id

    @property
    def name(self):
        """Gets the name of this BoundaryResponse.  # noqa: E501


        :return: The name of this BoundaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this BoundaryResponse.


        :param name: The name of this BoundaryResponse.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def type(self):
        """Gets the type of this BoundaryResponse.  # noqa: E501


        :return: The type of this BoundaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this BoundaryResponse.


        :param type: The type of this BoundaryResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["SURVEY", "REGION", "PLOT", "TILE"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def current_level(self):
        """Gets the current_level of this BoundaryResponse.  # noqa: E501


        :return: The current_level of this BoundaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._current_level

    @current_level.setter
    def current_level(self, current_level):
        """Sets the current_level of this BoundaryResponse.


        :param current_level: The current_level of this BoundaryResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["LEVEL_1", "LEVEL_2", "LEVEL_3", "LEVEL_4", "LEVEL_5", "LEVEL_6", "LEVEL_7"]  # noqa: E501
        if current_level not in allowed_values:
            raise ValueError(
                "Invalid value for `current_level` ({0}), must be one of {1}"  # noqa: E501
                .format(current_level, allowed_values)
            )

        self._current_level = current_level

    @property
    def geohash(self):
        """Gets the geohash of this BoundaryResponse.  # noqa: E501


        :return: The geohash of this BoundaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._geohash

    @geohash.setter
    def geohash(self, geohash):
        """Sets the geohash of this BoundaryResponse.


        :param geohash: The geohash of this BoundaryResponse.  # noqa: E501
        :type: str
        """

        self._geohash = geohash

    @property
    def area_in_hectares(self):
        """Gets the area_in_hectares of this BoundaryResponse.  # noqa: E501


        :return: The area_in_hectares of this BoundaryResponse.  # noqa: E501
        :rtype: float
        """
        return self._area_in_hectares

    @area_in_hectares.setter
    def area_in_hectares(self, area_in_hectares):
        """Sets the area_in_hectares of this BoundaryResponse.


        :param area_in_hectares: The area_in_hectares of this BoundaryResponse.  # noqa: E501
        :type: float
        """

        self._area_in_hectares = area_in_hectares

    @property
    def external_id(self):
        """Gets the external_id of this BoundaryResponse.  # noqa: E501


        :return: The external_id of this BoundaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._external_id

    @external_id.setter
    def external_id(self, external_id):
        """Sets the external_id of this BoundaryResponse.


        :param external_id: The external_id of this BoundaryResponse.  # noqa: E501
        :type: str
        """

        self._external_id = external_id

    @property
    def tile_details(self):
        """Gets the tile_details of this BoundaryResponse.  # noqa: E501


        :return: The tile_details of this BoundaryResponse.  # noqa: E501
        :rtype: dict(str, list[str])
        """
        return self._tile_details

    @tile_details.setter
    def tile_details(self, tile_details):
        """Sets the tile_details of this BoundaryResponse.


        :param tile_details: The tile_details of this BoundaryResponse.  # noqa: E501
        :type: dict(str, list[str])
        """

        self._tile_details = tile_details

    @property
    def geo_hierarchy(self):
        """Gets the geo_hierarchy of this BoundaryResponse.  # noqa: E501


        :return: The geo_hierarchy of this BoundaryResponse.  # noqa: E501
        :rtype: list[dict(str, str)]
        """
        return self._geo_hierarchy

    @geo_hierarchy.setter
    def geo_hierarchy(self, geo_hierarchy):
        """Sets the geo_hierarchy of this BoundaryResponse.


        :param geo_hierarchy: The geo_hierarchy of this BoundaryResponse.  # noqa: E501
        :type: list[dict(str, str)]
        """

        self._geo_hierarchy = geo_hierarchy

    @property
    def crop_details(self):
        """Gets the crop_details of this BoundaryResponse.  # noqa: E501


        :return: The crop_details of this BoundaryResponse.  # noqa: E501
        :rtype: list[CropDetail]
        """
        return self._crop_details

    @crop_details.setter
    def crop_details(self, crop_details):
        """Sets the crop_details of this BoundaryResponse.


        :param crop_details: The crop_details of this BoundaryResponse.  # noqa: E501
        :type: list[CropDetail]
        """

        self._crop_details = crop_details

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(BoundaryResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BoundaryResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
