# coding: utf-8

"""
    Insights Service API -test

    ## Introduction  Swaggerâ¢ is a project used to describe and document RESTful APIs. This section provides an overview of the API design, methods, and supported use cases.    Most of the endpoints accept **JSON** as input and return **JSON** responses.  ```  Content-type: application/json   Accept: application/json  ```  ## Resources  A resource in Swagger is an entity that has a set of exposed operations. The entity can represent an actual object (account, users..) or a set of logical operations collated together. It is up to the specification user to decide whether sub-resources should be referred to as part of their main resource or as a resource of their own. For example, assume the following URL set:     ```    /users         -GET                   POST                    /users/{id}    -GET                   PATCH                   DELETE   ```    ## CRUD Operations  The platform supports Create, Read, Update, and Delete operations on most resources. You can review the standards for these operations and their standard parameters below.    Some endpoints have special behavior as exceptions.    ### Create  To create a resource, you typically submit an HTTP POST request with the resource's required metadata in the request body. The response returns a 201 Created response code upon success with the resource's metadata, including its internal id, in the response body.    ### Read  The HTTP GET request can be used to read a resource or to list a number of resources.    A resource's id can be submitted in the request parameters to read a specific resource. The response usually returns a 200 OK response code upon success, with the resource's metadata in the response body.    If a GET request does not include a specific resource id, it is treated as a list request. The response usually returns a 200 OK response code upon success, with an object containing a list of resources' metadata in the response body.    When reading resources, some common query parameters are usually available. e.g. :  ```  v1/users?size=25&page=1  ```  **Query Parameter Type Description**  - size should be between 10 and 300 (default value 50)    - page should be a zero or any positive number (default value 0)    ### Update  Updating a resource requires the resource id, and is typically done using an HTTP PATCH request, with the fields to modify in the request body. The response usually returns a 200 OK response code upon success, with information about the modified resource in the response body.    ### Delete  Deleting a resource requires the resource id and is typically executing via an HTTP DELETE request. The response usually returns a 204 No Content response code upon success.    ## Trying the API  You can use [Swagger UI](https://swagger.io/tools/swagger-ui/) or any third party client such as ,[Postman](https://www.postman.com/), [cURL](https://curl.se/) etc. to test the REST API.    **Swagger UI**    - Authorize API by clicking on **Authorize** button.   - Select an API resource  - Click on **Try it out**   - filterQuery (Parameters): If required add parameters else keep blank json  ```   e.g.   {           \"size\": 300,           \"page\": 0,          }             e.g.   {          }            ```              - Fill the headers like TenantType, OrgId & X-Api-Key   - Click on **Execute**    **Curl**  ```  curl -X 'GET' \\  'http://localhost:8085/api/v1/crops' \\  -H 'accept: application/json' \\  -H 'TenantType: SMARTRISK' \\  -H 'orgId: test' \\  -H 'X-Api-Key: qwjokooopppp' \\  -H 'Authorization: Bearer jklkopalkddlplplllllllllll2340k'  ```  Using a graphical tool such as Postman, it is possible to import the API specifications directly:    - Download the API specification by clicking the **Download** button at top of this document  - Import the JSON specification in the graphical tool of your choice.  - In *Postman*, you can click the import button at the top    ## Enabling CORS  [Cross-origin resource sharing (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) is a browser security feature that restricts HTTP requests that are initiated from scripts running in the browser.      ## Authentication  The API authentication process validates the identity of the client attempting to make a connection by using an authentication protocol. REST API support many authentication methods which are as follows :    **HTTP Authentication Schemes**:    - Basic  - Bearer  - Digest  - OAuth and others...    Insights Service uses Bearer Authentication (also called token authentication) is an HTTP authentication scheme that involves security tokens called bearer tokens.    **Access Token** can be generated by following API by passing valid request payload (see Authenticate API)  ```  POST   /api/v1/authenticate  ```    For more details on authentication, see [API Authentication](https://www.3pillarglobal.com/insights/most-popular-api-authentication-methods).    ## Errors  The REST API reports errors by returning an appropriate HTTP response code, for example 404 (Not Found), and a JSON response. Any HTTP response code that is not in the range 200 - 299 is considered an error.    ### BadRequest (400)  This response means that the server cannot or will not process the request due to something that is perceived to be a client error (e.g., malformed request syntax, invalid request message framing, or deceptive request routing). To resolve this, please ensure that your syntax is correct.  ### Unauthorized (401)  Indicates that the request requires user authentication information. The client may repeat the request with a suitable Authorization header field.    ### Forbidden (403)  Unauthorized request. The client does not have access rights to the content. Unlike 401, the clientâs identity is known to the server.    ### NotFound (404)  The server can not find the requested resource.    ### MethodNotAllowed (405)  The request HTTP method is known by the server but has been disabled and cannot be used for that resource.  ### NotAcceptable (406)  The server does not find any content that conforms to the criteria given by the user agent in header sent in the request.  ### AlreadyExists  The request could not be completed due to a conflict with the current state of the target resource, e.g. the resource it tries to create already exists.  ### Internal Server Error (500)  The server encountered an unexpected condition that prevented it from fulfilling the request.    For more details on HTTP Status code see [HTTP Status Codes](https://restfulapi.net/http-status-codes/)   # noqa: E501

    OpenAPI spec version: v1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class SatelliteMetricsResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'created_date_time': 'datetime',
        'modified_date_time': 'datetime',
        'status': 'str',
        'properties': 'dict(str, object)',
        'tenant_type': 'str',
        'org_id': 'str',
        'boundary_id': 'str',
        'boundary_type': 'str',
        'captured_date_time': 'datetime',
        'unit_version': 'str',
        'metrics': 'Metrics',
        'geo_hierarchy': 'list[dict(str, str)]',
        'model_info': 'ModelInfo'
    }

    attribute_map = {
        'id': 'id',
        'created_date_time': 'createdDateTime',
        'modified_date_time': 'modifiedDateTime',
        'status': 'status',
        'properties': 'properties',
        'tenant_type': 'tenantType',
        'org_id': 'orgId',
        'boundary_id': 'boundaryId',
        'boundary_type': 'boundaryType',
        'captured_date_time': 'capturedDateTime',
        'unit_version': 'unitVersion',
        'metrics': 'metrics',
        'geo_hierarchy': 'geoHierarchy',
        'model_info': 'modelInfo'
    }

    def __init__(self, id=None, created_date_time=None, modified_date_time=None, status=None, properties=None, tenant_type=None, org_id=None, boundary_id=None, boundary_type=None, captured_date_time=None, unit_version=None, metrics=None, geo_hierarchy=None, model_info=None):  # noqa: E501
        """SatelliteMetricsResponse - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._created_date_time = None
        self._modified_date_time = None
        self._status = None
        self._properties = None
        self._tenant_type = None
        self._org_id = None
        self._boundary_id = None
        self._boundary_type = None
        self._captured_date_time = None
        self._unit_version = None
        self._metrics = None
        self._geo_hierarchy = None
        self._model_info = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if created_date_time is not None:
            self.created_date_time = created_date_time
        if modified_date_time is not None:
            self.modified_date_time = modified_date_time
        if status is not None:
            self.status = status
        if properties is not None:
            self.properties = properties
        if tenant_type is not None:
            self.tenant_type = tenant_type
        if org_id is not None:
            self.org_id = org_id
        if boundary_id is not None:
            self.boundary_id = boundary_id
        if boundary_type is not None:
            self.boundary_type = boundary_type
        if captured_date_time is not None:
            self.captured_date_time = captured_date_time
        if unit_version is not None:
            self.unit_version = unit_version
        if metrics is not None:
            self.metrics = metrics
        if geo_hierarchy is not None:
            self.geo_hierarchy = geo_hierarchy
        if model_info is not None:
            self.model_info = model_info

    @property
    def id(self):
        """Gets the id of this SatelliteMetricsResponse.  # noqa: E501


        :return: The id of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this SatelliteMetricsResponse.


        :param id: The id of this SatelliteMetricsResponse.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def created_date_time(self):
        """Gets the created_date_time of this SatelliteMetricsResponse.  # noqa: E501


        :return: The created_date_time of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._created_date_time

    @created_date_time.setter
    def created_date_time(self, created_date_time):
        """Sets the created_date_time of this SatelliteMetricsResponse.


        :param created_date_time: The created_date_time of this SatelliteMetricsResponse.  # noqa: E501
        :type: datetime
        """

        self._created_date_time = created_date_time

    @property
    def modified_date_time(self):
        """Gets the modified_date_time of this SatelliteMetricsResponse.  # noqa: E501


        :return: The modified_date_time of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._modified_date_time

    @modified_date_time.setter
    def modified_date_time(self, modified_date_time):
        """Sets the modified_date_time of this SatelliteMetricsResponse.


        :param modified_date_time: The modified_date_time of this SatelliteMetricsResponse.  # noqa: E501
        :type: datetime
        """

        self._modified_date_time = modified_date_time

    @property
    def status(self):
        """Gets the status of this SatelliteMetricsResponse.  # noqa: E501


        :return: The status of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this SatelliteMetricsResponse.


        :param status: The status of this SatelliteMetricsResponse.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def properties(self):
        """Gets the properties of this SatelliteMetricsResponse.  # noqa: E501


        :return: The properties of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """Sets the properties of this SatelliteMetricsResponse.


        :param properties: The properties of this SatelliteMetricsResponse.  # noqa: E501
        :type: dict(str, object)
        """

        self._properties = properties

    @property
    def tenant_type(self):
        """Gets the tenant_type of this SatelliteMetricsResponse.  # noqa: E501


        :return: The tenant_type of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: str
        """
        return self._tenant_type

    @tenant_type.setter
    def tenant_type(self, tenant_type):
        """Sets the tenant_type of this SatelliteMetricsResponse.


        :param tenant_type: The tenant_type of this SatelliteMetricsResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["SMARTFARM", "SMARTFARM_PLUS", "SMARTRISK", "API_USER", "SF_PLUS_API"]  # noqa: E501
        if tenant_type not in allowed_values:
            raise ValueError(
                "Invalid value for `tenant_type` ({0}), must be one of {1}"  # noqa: E501
                .format(tenant_type, allowed_values)
            )

        self._tenant_type = tenant_type

    @property
    def org_id(self):
        """Gets the org_id of this SatelliteMetricsResponse.  # noqa: E501


        :return: The org_id of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: str
        """
        return self._org_id

    @org_id.setter
    def org_id(self, org_id):
        """Sets the org_id of this SatelliteMetricsResponse.


        :param org_id: The org_id of this SatelliteMetricsResponse.  # noqa: E501
        :type: str
        """

        self._org_id = org_id

    @property
    def boundary_id(self):
        """Gets the boundary_id of this SatelliteMetricsResponse.  # noqa: E501


        :return: The boundary_id of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: str
        """
        return self._boundary_id

    @boundary_id.setter
    def boundary_id(self, boundary_id):
        """Sets the boundary_id of this SatelliteMetricsResponse.


        :param boundary_id: The boundary_id of this SatelliteMetricsResponse.  # noqa: E501
        :type: str
        """

        self._boundary_id = boundary_id

    @property
    def boundary_type(self):
        """Gets the boundary_type of this SatelliteMetricsResponse.  # noqa: E501


        :return: The boundary_type of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: str
        """
        return self._boundary_type

    @boundary_type.setter
    def boundary_type(self, boundary_type):
        """Sets the boundary_type of this SatelliteMetricsResponse.


        :param boundary_type: The boundary_type of this SatelliteMetricsResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["SURVEY", "REGION", "PLOT", "TILE"]  # noqa: E501
        if boundary_type not in allowed_values:
            raise ValueError(
                "Invalid value for `boundary_type` ({0}), must be one of {1}"  # noqa: E501
                .format(boundary_type, allowed_values)
            )

        self._boundary_type = boundary_type

    @property
    def captured_date_time(self):
        """Gets the captured_date_time of this SatelliteMetricsResponse.  # noqa: E501


        :return: The captured_date_time of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._captured_date_time

    @captured_date_time.setter
    def captured_date_time(self, captured_date_time):
        """Sets the captured_date_time of this SatelliteMetricsResponse.


        :param captured_date_time: The captured_date_time of this SatelliteMetricsResponse.  # noqa: E501
        :type: datetime
        """

        self._captured_date_time = captured_date_time

    @property
    def unit_version(self):
        """Gets the unit_version of this SatelliteMetricsResponse.  # noqa: E501


        :return: The unit_version of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: str
        """
        return self._unit_version

    @unit_version.setter
    def unit_version(self, unit_version):
        """Sets the unit_version of this SatelliteMetricsResponse.


        :param unit_version: The unit_version of this SatelliteMetricsResponse.  # noqa: E501
        :type: str
        """

        self._unit_version = unit_version

    @property
    def metrics(self):
        """Gets the metrics of this SatelliteMetricsResponse.  # noqa: E501


        :return: The metrics of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: Metrics
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics):
        """Sets the metrics of this SatelliteMetricsResponse.


        :param metrics: The metrics of this SatelliteMetricsResponse.  # noqa: E501
        :type: Metrics
        """

        self._metrics = metrics

    @property
    def geo_hierarchy(self):
        """Gets the geo_hierarchy of this SatelliteMetricsResponse.  # noqa: E501


        :return: The geo_hierarchy of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: list[dict(str, str)]
        """
        return self._geo_hierarchy

    @geo_hierarchy.setter
    def geo_hierarchy(self, geo_hierarchy):
        """Sets the geo_hierarchy of this SatelliteMetricsResponse.


        :param geo_hierarchy: The geo_hierarchy of this SatelliteMetricsResponse.  # noqa: E501
        :type: list[dict(str, str)]
        """

        self._geo_hierarchy = geo_hierarchy

    @property
    def model_info(self):
        """Gets the model_info of this SatelliteMetricsResponse.  # noqa: E501


        :return: The model_info of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: ModelInfo
        """
        return self._model_info

    @model_info.setter
    def model_info(self, model_info):
        """Sets the model_info of this SatelliteMetricsResponse.


        :param model_info: The model_info of this SatelliteMetricsResponse.  # noqa: E501
        :type: ModelInfo
        """

        self._model_info = model_info

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SatelliteMetricsResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SatelliteMetricsResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
