# coding: utf-8

"""
    Insights Service API -test

    ## Introduction  Swaggerâ¢ is a project used to describe and document RESTful APIs. This section provides an overview of the API design, methods, and supported use cases.    Most of the endpoints accept **JSON** as input and return **JSON** responses.  ```  Content-type: application/json   Accept: application/json  ```  ## Resources  A resource in Swagger is an entity that has a set of exposed operations. The entity can represent an actual object (account, users..) or a set of logical operations collated together. It is up to the specification user to decide whether sub-resources should be referred to as part of their main resource or as a resource of their own. For example, assume the following URL set:     ```    /users         -GET                   POST                    /users/{id}    -GET                   PATCH                   DELETE   ```    ## CRUD Operations  The platform supports Create, Read, Update, and Delete operations on most resources. You can review the standards for these operations and their standard parameters below.    Some endpoints have special behavior as exceptions.    ### Create  To create a resource, you typically submit an HTTP POST request with the resource's required metadata in the request body. The response returns a 201 Created response code upon success with the resource's metadata, including its internal id, in the response body.    ### Read  The HTTP GET request can be used to read a resource or to list a number of resources.    A resource's id can be submitted in the request parameters to read a specific resource. The response usually returns a 200 OK response code upon success, with the resource's metadata in the response body.    If a GET request does not include a specific resource id, it is treated as a list request. The response usually returns a 200 OK response code upon success, with an object containing a list of resources' metadata in the response body.    When reading resources, some common query parameters are usually available. e.g. :  ```  v1/users?size=25&page=1  ```  **Query Parameter Type Description**  - size should be between 10 and 300 (default value 50)    - page should be a zero or any positive number (default value 0)    ### Update  Updating a resource requires the resource id, and is typically done using an HTTP PATCH request, with the fields to modify in the request body. The response usually returns a 200 OK response code upon success, with information about the modified resource in the response body.    ### Delete  Deleting a resource requires the resource id and is typically executing via an HTTP DELETE request. The response usually returns a 204 No Content response code upon success.    ## Trying the API  You can use [Swagger UI](https://swagger.io/tools/swagger-ui/) or any third party client such as ,[Postman](https://www.postman.com/), [cURL](https://curl.se/) etc. to test the REST API.    **Swagger UI**    - Authorize API by clicking on **Authorize** button.   - Select an API resource  - Click on **Try it out**   - filterQuery (Parameters): If required add parameters else keep blank json  ```   e.g.   {           \"size\": 300,           \"page\": 0,          }             e.g.   {          }            ```              - Fill the headers like TenantType, OrgId & X-Api-Key   - Click on **Execute**    **Curl**  ```  curl -X 'GET' \\  'http://localhost:8085/api/v1/crops' \\  -H 'accept: application/json' \\  -H 'TenantType: SMARTRISK' \\  -H 'orgId: test' \\  -H 'X-Api-Key: qwjokooopppp' \\  -H 'Authorization: Bearer jklkopalkddlplplllllllllll2340k'  ```  Using a graphical tool such as Postman, it is possible to import the API specifications directly:    - Download the API specification by clicking the **Download** button at top of this document  - Import the JSON specification in the graphical tool of your choice.  - In *Postman*, you can click the import button at the top    ## Enabling CORS  [Cross-origin resource sharing (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) is a browser security feature that restricts HTTP requests that are initiated from scripts running in the browser.      ## Authentication  The API authentication process validates the identity of the client attempting to make a connection by using an authentication protocol. REST API support many authentication methods which are as follows :    **HTTP Authentication Schemes**:    - Basic  - Bearer  - Digest  - OAuth and others...    Insights Service uses Bearer Authentication (also called token authentication) is an HTTP authentication scheme that involves security tokens called bearer tokens.    **Access Token** can be generated by following API by passing valid request payload (see Authenticate API)  ```  POST   /api/v1/authenticate  ```    For more details on authentication, see [API Authentication](https://www.3pillarglobal.com/insights/most-popular-api-authentication-methods).    ## Errors  The REST API reports errors by returning an appropriate HTTP response code, for example 404 (Not Found), and a JSON response. Any HTTP response code that is not in the range 200 - 299 is considered an error.    ### BadRequest (400)  This response means that the server cannot or will not process the request due to something that is perceived to be a client error (e.g., malformed request syntax, invalid request message framing, or deceptive request routing). To resolve this, please ensure that your syntax is correct.  ### Unauthorized (401)  Indicates that the request requires user authentication information. The client may repeat the request with a suitable Authorization header field.    ### Forbidden (403)  Unauthorized request. The client does not have access rights to the content. Unlike 401, the clientâs identity is known to the server.    ### NotFound (404)  The server can not find the requested resource.    ### MethodNotAllowed (405)  The request HTTP method is known by the server but has been disabled and cannot be used for that resource.  ### NotAcceptable (406)  The server does not find any content that conforms to the criteria given by the user agent in header sent in the request.  ### AlreadyExists  The request could not be completed due to a conflict with the current state of the target resource, e.g. the resource it tries to create already exists.  ### Internal Server Error (500)  The server encountered an unexpected condition that prevented it from fulfilling the request.    For more details on HTTP Status code see [HTTP Status Codes](https://restfulapi.net/http-status-codes/)   # noqa: E501

    OpenAPI spec version: v1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from insights_python_client.api_client import ApiClient


class MetricsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def list_all3(self, tenant_type, x_api_key, **kwargs):  # noqa: E501
        """Get satellite metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_all3(tenant_type, x_api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_type: TenantType (required)
        :param str x_api_key: X-Api-Key (required)
        :param str org_id: Optional for TenantType - SMARTRISK
        :param str page: Page no. should be a positive number
        :param str size: Page size should be between 10 and 300
        :param str sort_by: Sort by given parameter name
        :param str direction: Order by ascending or descending fashion
        :param str ids: Filter by ids, it can be single id or list
        :param str boundary_id: Filter by boundaryId
        :param str captured_date_time: Filter by capturedDateTime
        :param str min_cloud_coverage: Filters by cloudCoverge >= minCloudCoverage
        :param str max_cloud_coverage: Filters by cloudCoverge <= maxCloudCoverage
        :return: SatelliteMetricsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_all3_with_http_info(tenant_type, x_api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.list_all3_with_http_info(tenant_type, x_api_key, **kwargs)  # noqa: E501
            return data

    def list_all3_with_http_info(self, tenant_type, x_api_key, **kwargs):  # noqa: E501
        """Get satellite metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_all3_with_http_info(tenant_type, x_api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_type: TenantType (required)
        :param str x_api_key: X-Api-Key (required)
        :param str org_id: Optional for TenantType - SMARTRISK
        :param str page: Page no. should be a positive number
        :param str size: Page size should be between 10 and 300
        :param str sort_by: Sort by given parameter name
        :param str direction: Order by ascending or descending fashion
        :param str ids: Filter by ids, it can be single id or list
        :param str boundary_id: Filter by boundaryId
        :param str captured_date_time: Filter by capturedDateTime
        :param str min_cloud_coverage: Filters by cloudCoverge >= minCloudCoverage
        :param str max_cloud_coverage: Filters by cloudCoverge <= maxCloudCoverage
        :return: SatelliteMetricsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tenant_type', 'x_api_key', 'org_id', 'page', 'size', 'sort_by', 'direction', 'ids', 'boundary_id', 'captured_date_time', 'min_cloud_coverage', 'max_cloud_coverage']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_all3" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tenant_type' is set
        if ('tenant_type' not in params or
                params['tenant_type'] is None):
            raise ValueError("Missing the required parameter `tenant_type` when calling `list_all3`")  # noqa: E501
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `list_all3`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'sort_by' in params:
            query_params.append(('sortBy', params['sort_by']))  # noqa: E501
        if 'direction' in params:
            query_params.append(('direction', params['direction']))  # noqa: E501
        if 'ids' in params:
            query_params.append(('ids', params['ids']))  # noqa: E501
        if 'boundary_id' in params:
            query_params.append(('boundaryId', params['boundary_id']))  # noqa: E501
        if 'captured_date_time' in params:
            query_params.append(('capturedDateTime', params['captured_date_time']))  # noqa: E501
        if 'min_cloud_coverage' in params:
            query_params.append(('minCloudCoverage', params['min_cloud_coverage']))  # noqa: E501
        if 'max_cloud_coverage' in params:
            query_params.append(('maxCloudCoverage', params['max_cloud_coverage']))  # noqa: E501

        header_params = {}
        if 'tenant_type' in params:
            header_params['TenantType'] = params['tenant_type']  # noqa: E501
        if 'org_id' in params:
            header_params['OrgId'] = params['org_id']  # noqa: E501
        if 'x_api_key' in params:
            header_params['X-Api-Key'] = params['x_api_key']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/plots/data/satellite', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
