# coding: utf-8

"""
    Insights Service API -test

    ## Introduction to PlotRisk  PlotRisk is a module, which ease to create plot for the given area of interest and also   facilitate to check satellite indices, weather and yield data.    **Note**``  Indices, Weather and Yield data can be accessed based on features subscriptions.  ``  ## Resources  A resource is an entity that has a set of exposed operations. The entity can represent an actual object (account, users..) or a set of logical operations collated together. It is up to the specification user to decide whether sub-resources should be referred to as part of their main resource or as a resource of their own. For example, assume the following URL set:     ```    /users         -GET                   POST                    /users/{id}    -GET                   PATCH                   DELETE   ```  For more details, see [CRUD Operations](https://docs.microsoft.com/en-us/iis-administration/api/crud) to learn more about it.  ## Trying the API  You can use [Swagger UI](https://swagger.io/tools/swagger-ui/) or any third party client such as ,[Postman](https://www.postman.com/), [cURL](https://curl.se/) etc. to test the REST API.    **Swagger UI**    **Step 1.** Generate access tokens using **/token** resource      **Info** : ``If you are a SMARTFARM_PLUS user, you can request for tokens using tenant,username,password  ``    **Step 2.** Copy **_access_token_** from **Step 1**, then click on **Authorize** button and paste the token.    **Step 3.** Select an API resource and click on **_Try it out_**.    **Step 4.** Fill the headers such as _**TenantType**_, _**OrgId**_ & _**X-Api-Key**_.    **Info** : ``X-Api-Key can be obtained from Step 1  ``    **Step 5.**  Query parameters are optional. It filters result based on provided parameter value.  ```   e.g.   {           \"size\": 300,           \"page\": 0,          }             e.g.   {          }            ```   **Step 6.** Click on **Execute**    **Curl**  ```  curl -X 'GET' \\  'http://localhost:8085/api/v1/crops' \\  -H 'accept: application/json' \\  -H 'TenantType: SMARTRISK' \\  -H 'orgId: test' \\  -H 'X-Api-Key: qwjokooopppp' \\  -H 'Authorization: Bearer jklkopalkddlplplllllllllll2340k'  ```  Using a graphical tool such as Postman, it is possible to import the API specifications directly:    - Download the API specification by clicking the **swagger.json** hypelink at top of this document  - Import the JSON specification in the graphical tool of your choice.  - In *Postman*, you can click the import button at the top    ## Authentication  The API authentication process validates the identity of the client attempting to make a connection by using an authentication protocol.  **Access Token** is required to access PlotRisk APIs & same can be generated by following API on passing valid request payload (see Token API)  ```  POST   /tokens  ```    For more details, see [Authentication and Authorization](https://swagger.io/docs/specification/authentication/).    ## Errors  The REST API reports errors by returning an appropriate HTTP response code, for example 404 (Not Found), and a JSON response. Any HTTP response code that is not in the range 200 - 299 is considered an error.    For more details on HTTP Status code, see [HTTP Status Codes](https://restfulapi.net/http-status-codes/)   # noqa: E501

    OpenAPI spec version: v1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from insights_python_client.api_client import ApiClient


class FileApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_plot_image_for_satellite_and_health_indices(self, tenant_type, x_api_key, boundary_id, _date, image_name, **kwargs):  # noqa: E501
        """Download plot images  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_plot_image_for_satellite_and_health_indices(tenant_type, x_api_key, boundary_id, _date, image_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_type:  TenantType is an identifier to track API uses. Valid input : 'SMARTFARM_PLUS' (required)
        :param str x_api_key: Security key to grant access to APIs (required)
        :param str boundary_id:  Boundary Id (required)
        :param str _date: Indicates captured satellite date in yyyy-MM-dd format, e.g. date=2022-03-15 (required)
        :param str image_name: Plot image name, e.g imageName = NDRE (required)
        :param str org_id: OrgId represents unique Id for a company or entity
        :param str image_type: Plot image type, e.g imageType = TIFF
        :param str tile_size: Pixel size of tile, e.g. tileSize=[255,345]
        :return: PlotImageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_plot_image_for_satellite_and_health_indices_with_http_info(tenant_type, x_api_key, boundary_id, _date, image_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_plot_image_for_satellite_and_health_indices_with_http_info(tenant_type, x_api_key, boundary_id, _date, image_name, **kwargs)  # noqa: E501
            return data

    def get_plot_image_for_satellite_and_health_indices_with_http_info(self, tenant_type, x_api_key, boundary_id, _date, image_name, **kwargs):  # noqa: E501
        """Download plot images  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_plot_image_for_satellite_and_health_indices_with_http_info(tenant_type, x_api_key, boundary_id, _date, image_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_type:  TenantType is an identifier to track API uses. Valid input : 'SMARTFARM_PLUS' (required)
        :param str x_api_key: Security key to grant access to APIs (required)
        :param str boundary_id:  Boundary Id (required)
        :param str _date: Indicates captured satellite date in yyyy-MM-dd format, e.g. date=2022-03-15 (required)
        :param str image_name: Plot image name, e.g imageName = NDRE (required)
        :param str org_id: OrgId represents unique Id for a company or entity
        :param str image_type: Plot image type, e.g imageType = TIFF
        :param str tile_size: Pixel size of tile, e.g. tileSize=[255,345]
        :return: PlotImageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tenant_type', 'x_api_key', 'boundary_id', '_date', 'image_name', 'org_id', 'image_type', 'tile_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_plot_image_for_satellite_and_health_indices" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tenant_type' is set
        if ('tenant_type' not in params or
                params['tenant_type'] is None):
            raise ValueError("Missing the required parameter `tenant_type` when calling `get_plot_image_for_satellite_and_health_indices`")  # noqa: E501
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `get_plot_image_for_satellite_and_health_indices`")  # noqa: E501
        # verify the required parameter 'boundary_id' is set
        if ('boundary_id' not in params or
                params['boundary_id'] is None):
            raise ValueError("Missing the required parameter `boundary_id` when calling `get_plot_image_for_satellite_and_health_indices`")  # noqa: E501
        # verify the required parameter '_date' is set
        if ('_date' not in params or
                params['_date'] is None):
            raise ValueError("Missing the required parameter `_date` when calling `get_plot_image_for_satellite_and_health_indices`")  # noqa: E501
        # verify the required parameter 'image_name' is set
        if ('image_name' not in params or
                params['image_name'] is None):
            raise ValueError("Missing the required parameter `image_name` when calling `get_plot_image_for_satellite_and_health_indices`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'boundary_id' in params:
            query_params.append(('boundaryId', params['boundary_id']))  # noqa: E501
        if '_date' in params:
            query_params.append(('date', params['_date']))  # noqa: E501
        if 'image_name' in params:
            query_params.append(('imageName', params['image_name']))  # noqa: E501
        if 'image_type' in params:
            query_params.append(('imageType', params['image_type']))  # noqa: E501
        if 'tile_size' in params:
            query_params.append(('tileSize', params['tile_size']))  # noqa: E501

        header_params = {}
        if 'tenant_type' in params:
            header_params['TenantType'] = params['tenant_type']  # noqa: E501
        if 'org_id' in params:
            header_params['OrgId'] = params['org_id']  # noqa: E501
        if 'x_api_key' in params:
            header_params['X-Api-Key'] = params['x_api_key']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth']  # noqa: E501

        return self.api_client.call_api(
            '/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
