<div align="center">
  <h1>⚡️ Instant Boilerplate for Python Projects ⚡️</h1>
  <strong>Fast, easy and reliable project generator for your Python projects.</strong>
</div>

<p align="center">
  <a href="https://dimanu-py.github.io/instant-python/home/getting_started/">Getting Started</a>&nbsp;&nbsp;•&nbsp;
  <a href="https://dimanu-py.github.io/instant-python/guide/command_config/">Usage</a>&nbsp;&nbsp;•&nbsp;
  <a href="https://dimanu-py.github.io/instant-python/examples/configuration/">Examples</a>&nbsp;&nbsp;•&nbsp;
  <a href="https://dimanu-py.github.io/instant-python/home/contributing/">Contributing</a>
</p>

<div align="center"><table><tr><td>
<b>Instant Python</b> replaces extensive manual setup with a simple command to get started quickly. Its motivation is to emulate
commands like `ng new` or `create-react-app`, but for Python projects.

<br>

<b>Why use Instant Python?</b> Generating your Python project with Instant Python lets you:

<ul style="list-style-type: none">
  <li>⏱️ Slash folder & config setup time to seconds</li>
  <li>🐍 Instantly install & switch between any Python version</li>
  <li>🔧 Effortlessly configure your favorite project manager</li>
  <li>📁 Kickstart with ready-made or fully custom project structures</li>
  <li>🔄 Initialize a Git repo in just a few clicks</li>
  <li>📦 Auto-install all your go-to dependencies</li>
  <li>🚀 Ship with production-ready boilerplates out of the box</li>
</ul>

</td></tr></table></div>

## Navigation Guide

This section provides a high-level overview of the `instant-python` documentation
so can quickly find what you need.

- [Installation](https://dimanu-py.github.io/instant-python/home/#installation)
- [Getting Started](https://dimanu-py.github.io/instant-python/home/getting_started/)
- [Examples](https://dimanu-py.github.io/instant-python/examples/configuration/)

### For Users

- [Installation]: begin by learning how to install `instant-python`.
- [First Steps]: get started with the basic features of `instant-python`.
- [Advanced Usage and Customization]: explore advanced features and customization options.

[Installation]: https://dimanu-py.github.io/instant-python/getting_started/installation/
[First Steps]: https://dimanu-py.github.io/instant-python/getting_started/first_steps/
[Advanced Usage and Customization]: https://dimanu-py.github.io/instant-python/guide/

### For Developers

- [Contributing]: learn how to contribute to `instant-python` development.
- [Releases]: understand our release process and versioning.
- [Security]: understand our security policies and reporting procedures.

[Contributing]: https://dimanu-py.github.io/instant-python/development/contributing/
[Releases]: https://dimanu-py.github.io/instant-python/development/releases/
[Security]: https://dimanu-py.github.io/instant-python/development/security/

### Need help?

-   Join a discussion 💬 on [GitHub Discussions]
-   [Raise an issue][GitHub Issues] on GitHub

[GitHub Discussions]: https://github.com/dimanu-py/instant-python/discussions
[GitHub Issues]: https://github.com/dimanu-py/instant-python/issues

[//]: # (### Do Not Track)

[//]: # ()
[//]: # (In order to get better insights about the usage of the library, we collect anonymous usage data. The only)

[//]: # (data we collect is the commands you run. No personal data is collected as part of this request.)

[//]: # ()
[//]: # (You can disable this feature by setting the environment variable `INSTANT_PYTHON_NO_TRACK` to `1` or )

[//]: # (passing the `--no-track` option to any command.)

## Contributing

We welcome contributions to `instant-python`! If you have ideas, suggestions, or improvements, please check out our
[contributing guide](https://dimanu-py.github.io/instant-python/home/contributing/) for details on how to get involved.
