If you are in this section is because you want to learn more about all the configuration options available in `instant-python`
and how to create custom projects using the tool.

If you have followed our [Getting Started] section you already know the basics of how to use `instant-python` and its commands:

1. The first command will always be `ipy config`. This will create or update the configuration file that `instant-python` uses 
to generate projects through an interactive wizard.
2. Then you can create your project using the `ipy init` command, which reads the configuration file and generates the project accordingly.
What you may not know yet are the different options you can use with this command to customize its behavior:
    - `--config` or `-c` to specify a custom configuration file path.
    - `--templates` or `-t` to specify a path where you have your custom templates. This parameter will be covered in more detail
      in the [Customizing Projects] section.

## Quick Navigation

Use the buttons below to jump directly to the section you need:

| Section | Description |
|---------|-------------|
| [📋 Config Command](#what-you-will-find-in-this-section) | Learn how to configure your project |
| [⚡ Init Command](#what-you-will-find-in-this-section) | Understand the project initialization process |
| [🎨 Default Features](#what-you-will-find-in-this-section) | Explore built-in project templates and implementations |
| [🛠️ Custom Projects](#what-you-will-find-in-this-section) | Create your own custom project templates |

## What you will find in this section

1. [Config Command]: We will review how to use the `config` command and explain how the configuration file is structured
   and all the available options you can set.
2. [Default Features]: A detailed explanation of all the built-in features that `instant-python` provides
   to include in your projects.
3. [Init Command]: A deep dive into the `init` command
4. [Customizing Projects]: A complete guide on how to create your own custom project templates and use them with `instant-python`.

[Getting Started]: ../getting_started/first_steps.md
[Config Command]: command_config.md
[Default Features]: default_features.md
[Init Command]: command_init.md
[Customizing Projects]: custom_projects.md