# Installation

To ensure a clean and isolated environment, we recommend installing `instant-python` using a virtual environment.
Below are the preferred installation methods.

## Using `pipx`

The recommended way to install `instant-python` is using `pipx`. `pipx` installs Python applications in isolated environments, ensuring that
they do not interfere with other Python applications.

```bash
pipx install instant-python
```

If you do not have `pipx` installed, you can install it using `pip`.

```bash
pip install --user pipx
```

## Using `pyenv`

If you already manage your Python versions using a tool like Pyenv, you can install `instant-python` using `pip` with
pyenv's global Python version.

```bash
pip install instant-python
```

A guide to install and configure pyenv can be found [here](https://github.com/pyenv/pyenv?tab=readme-ov-file#installation)

## Next steps

See the [first steps](./first-steps.md) or jump to the [guide](../guide/index.md) section to learn more about `instant-python` commands.
