<div align="center">
  <h1>⚡️ Instant Boilerplate for Python Projects ⚡️</h1>
  <strong>Start your Python project right away</strong>
</div>
<p align="center">
  <a href="https://dimanu-py.github.io/instant-python/getting-started/">Getting Started</a>&nbsp;&nbsp;•&nbsp;
  <a href="https://dimanu-py.github.io/instant-python/guide">Guide</a>&nbsp;&nbsp;•&nbsp;
  <a href="https://dimanu-py.github.io/instant-python/contributing">Contributing</a>
</p>
<p align="center">
  <img 
    src="https://github.com/user-attachments/assets/132513c0-e472-4523-a0fd-c27b70dfd78a"
    alt="instant-python-demo" 
    width="80%"
  />
  <br>
</p>

## Installation

Install `instant-python` from PyPI:

```bash
# With pipx
pipx install instant-python
```
```bash
# With pip in pyenv
pip install instant-python
```

## Documentation

The official documentation is available at [dimanu-py.github.io/instant-python](https://dimanu-py.github.io/instant-python).
We recommend to visit the page to understand the features and how to use the library.

Additionally, you can also run the help command to get started:

```bash
ipy --help
```

## Features

With `instant-python` there is a lot of features you can customize easily so you can start coding on your project
as soon as possible. An overview of the features is given below, but you can find a more detailed explanation in the
[documentation](https://dimanu-py.github.io/instant-python/guide/features/).

- Project slug: Configure the name of the main folder of your project.
- Source name: Configure the name of the source code folder of your project.
- Description: Include a description about your project.
- Version: Set the initial version of your project.
- Author: Set the author of the project.
- License: Choose between _MIT_, _Apache_ or _GPL_ licenses to set your project.
- Python version: Select the Python version you want to use for your project between versions 3.13 to 3.10.
- Dependency manager: Choose between _uv_ or _pdm_ dependency managers.
- Git: configure your project as a git repository automatically.
- Default templates: select your project template between Domain Driven Design, Clean Architecture or Standard Project to
automatically generate your project folders and files.
- Out of the box implementations: include some boilerplate and implementations code that will help you to start your project faster.
Some of the most popular implementations are value objects, domain error modelling, makefile and Async SQL Alchemy.
- Dependencies: install dependencies automatically in your project.
