<div align="center">
  <h1>⚡️ Instant Boilerplate for Python Projects ⚡️</h1>
  <strong>Fast, easy and reliable project generator for your Python projects.</strong>
</div>

<p align="center">
  <a href="https://dimanu-py.github.io/instant-python/home/getting_started/">Getting Started</a>&nbsp;&nbsp;•&nbsp;
  <a href="https://dimanu-py.github.io/instant-python/guide/command_config/">Usage</a>&nbsp;&nbsp;•&nbsp;
  <a href="https://dimanu-py.github.io/instant-python/examples/configuration/">Examples</a>&nbsp;&nbsp;•&nbsp;
  <a href="https://dimanu-py.github.io/instant-python/home/contributing/">Contributing</a>
</p>
<p align="center">
  <img 
    src="https://github.com/user-attachments/assets/132513c0-e472-4523-a0fd-c27b70dfd78a"
    alt="instant-python-demo" 
    width="80%"
  />
  <br>
</p>

<div align="center"><table><tr><td>
<b>Instant Python</b> replaces extensive manual setup with a simple command to get started quickly. Its motivation is to emulate
commands like `ng new` or `create-react-app`, but for Python projects.

<br><br>

<b>Why use Instant Python?</b> Generating your Python project with Instant Python lets you:

<ul style="list-style-type: none">
  <li>⏱️ Slash folder & config setup time to seconds</li>
  <li>🐍 Instantly install & switch between any Python version</li>
  <li>🔧 Effortlessly configure your favorite project manager</li>
  <li>📁 Kickstart with ready-made or fully custom project structures</li>
  <li>🔄 Initialize a Git repo in just a few clicks</li>
  <li>📦 Auto-install all your go-to dependencies</li>
  <li>🚀 Ship with production-ready boilerplates out of the box</li>
</ul>

</td></tr></table></div>

## Documentation

This section provides a high-level overview of the `instant-python` library, its features, and how to get started.
For detailed instructions and examples, please refer to the [full Instant Python documentation](https://dimanu-py.github.io/instant-python/).

- [Installation](#installation)
- [Getting Started](docs/home/getting_started.md)
- [Examples](./docs/examples/index.md)

### Need help?

-   Join a discussion 💬 on [GitHub Discussions]
-   [Raise an issue][GitHub Issues] on GitHub

[GitHub Discussions]: https://github.com/dimanu-py/instant-python/discussions
[GitHub Issues]: https://github.com/dimanu-py/instant-python/issues

## Installation

The latest version of `instant-python` can be installed from PyPI:

```bash
pip install instant-python
```

> [!TIP]
> We highly recommend using a virtual environment to avoid conflicts with other Python packages.

### Requirements

Instant Python tries to support the latest Python versions, we officially support from Python 3.10 to 3.13.
Older versions of Python may work, but they are not guaranteed to be compatible.

[//]: # (### Do Not Track)

[//]: # ()
[//]: # (In order to get better insights about the usage of the library, we collect anonymous usage data. The only)

[//]: # (data we collect is the commands you run. No personal data is collected as part of this request.)

[//]: # ()
[//]: # (You can disable this feature by setting the environment variable `INSTANT_PYTHON_NO_TRACK` to `1` or )

[//]: # (passing the `--no-track` option to any command.)

## Contributing

We welcome contributions to `instant-python`! If you have ideas, suggestions, or improvements, please check out our
[contributing guide](docs/home/contributing.md) for details on how to get involved.
