# Description

## Type of change

- [ ] **✨ feat**: New feature (non-breaking change).
- [ ] **🐛 fix**: Bug fix (non-breaking change).
- [ ] **📝 docs**: Documentation update.
- [ ] **♻️ refactor**: Code change that neither fixes a bug nor adds a new feature.
- [ ] **⚡️ perf**: Performance improvement.
- [ ] **🧪 test**: Update suite of tests.
- [ ] **📦️ build**: Changes that affect the build system (new dependencies, tools, ...).
- [ ] **💚 ci**: Pipeline changes (GitHub Actions, make commands, ...).
- [ ] **💥 BREAKING CHANGE**: Feature, fix, ... that breaks backward compatibility.
- [ ] **👽️ others**: Other type of change.

## Related Issues / Discussions / Resources

## Pre-merge Checklist

- [ ] I have read and followed the [`Contributor Guidelines`](https://github.com/dimanu-py/instant-python/blob/main/docs/home/contributing.md).
- [ ] My pull requests and commits follow the [Conventional Commits](https://www.conventionalcommits.org) and [Conventional Comments](https://conventionalcomments.org) guidelines.
- [ ] My code follows the coding guidelines of the project ([PEP 8](https://peps.python.org/pep-0008), [PEP 257](https://peps.python.org/pep-0257), ...).
- [ ] My changes generate no new warnings (execution, linter, formatter, ...).
- [ ] I have updated the suite of tests required for this change.
- [ ] I have made corresponding changes to the documentation.
- [ ] I considered security & backwards-compatibility; if **breaking**, explain in the "Description" section above.

## 📃 Additional Resources

- [The Anatomy of a Perfect Pull Request](https://hugooodias.medium.com/the-anatomy-of-a-perfect-pull-request-567382bb6067)