import socket


def get_host_ip():
    try:
        ip = socket.gethostbyname(socket.gethostname())
    except Exception:
        try:
            s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
            s.connect(('8.8.8.8', 80))
            ip = s.getsockname()[0]
        finally:
            s.close()
    if not ip:
        raise socket.gaierror(-2, 'Name or service not known')
    return ip
