# invision-client-python
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.1
- Package version: 1.0.1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import invision_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import invision_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import invision_client
from pprint import pprint
from invision_client.api import forums_api
# Defining the host is optional and defaults to https://tech.forums.silabs.net/api
# See configuration.py for a list of all supported configuration parameters.
configuration = invision_client.Configuration(
    host = "https://tech.forums.silabs.net/api"
)



# Enter a context with an instance of the API client
with invision_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = forums_api.ForumsApi(api_client)
    clubs = 1 # int | Include club forums. 0: No, 1: Yes (default) (optional) (default to 1)
    page = 1 # int | Page number (optional)
    per_page = 25 # int | Number of results per page. Defaults to 25 (optional) (default to 25)

    try:
        # Get list of forums
        api_response = api_instance.forums_forums_get(clubs=clubs, page=page, per_page=per_page)
        pprint(api_response)
    except invision_client.ApiException as e:
        print("Exception when calling ForumsApi->forums_forums_get: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://tech.forums.silabs.net/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ForumsApi* | [**forums_forums_get**](docs/ForumsApi.md#forums_forums_get) | **GET** /forums/forums | Get list of forums
*MembersApi* | [**core_members_get**](docs/MembersApi.md#core_members_get) | **GET** /core/members | Get list of members
*TopicsApi* | [**forums_topics_post**](docs/TopicsApi.md#forums_topics_post) | **POST** /forums/topics | Create a topic


## Documentation For Models

 - [Field](docs/Field.md)
 - [FieldGroup](docs/FieldGroup.md)
 - [Forum](docs/Forum.md)
 - [ForumPermissions](docs/ForumPermissions.md)
 - [Group](docs/Group.md)
 - [Member](docs/Member.md)
 - [PollOptionObject](docs/PollOptionObject.md)
 - [PollOptionObjectAnswersInner](docs/PollOptionObjectAnswersInner.md)
 - [Post](docs/Post.md)
 - [Rank](docs/Rank.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in invision_client.apis and invision_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from invision_client.api.default_api import DefaultApi`
- `from invision_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import invision_client
from invision_client.apis import *
from invision_client.models import *
```

