"""
    Invision Community API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from invision_client.api_client import ApiClient, Endpoint as _Endpoint
from invision_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from invision_client.model.poll_option_object import PollOptionObject


class TopicsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.forums_topics_post_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/forums/topics',
                'operation_id': 'forums_topics_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'forum',
                    'title',
                    'post',
                    'author',
                    'author_name',
                    'prefix',
                    'tags',
                    'date',
                    'ip_address',
                    'locked',
                    'open_time',
                    'close_time',
                    'hidden',
                    'pinned',
                    'featured',
                    'poll_title',
                    'poll_public',
                    'poll_only',
                    'poll_options',
                ],
                'required': [
                    'forum',
                    'title',
                    'post',
                    'author',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'forum':
                        (int,),
                    'title':
                        (str,),
                    'post':
                        (str,),
                    'author':
                        (int,),
                    'author_name':
                        (str,),
                    'prefix':
                        (str,),
                    'tags':
                        (str,),
                    'date':
                        (datetime,),
                    'ip_address':
                        (str,),
                    'locked':
                        (int,),
                    'open_time':
                        (datetime,),
                    'close_time':
                        (datetime,),
                    'hidden':
                        (int,),
                    'pinned':
                        (int,),
                    'featured':
                        (int,),
                    'poll_title':
                        (str,),
                    'poll_public':
                        (int,),
                    'poll_only':
                        (int,),
                    'poll_options':
                        ([PollOptionObject],),
                },
                'attribute_map': {
                    'forum': 'forum',
                    'title': 'title',
                    'post': 'post',
                    'author': 'author',
                    'author_name': 'author_name',
                    'prefix': 'prefix',
                    'tags': 'tags',
                    'date': 'date',
                    'ip_address': 'ip_address',
                    'locked': 'locked',
                    'open_time': 'open_time',
                    'close_time': 'close_time',
                    'hidden': 'hidden',
                    'pinned': 'pinned',
                    'featured': 'featured',
                    'poll_title': 'poll_title',
                    'poll_public': 'poll_public',
                    'poll_only': 'poll_only',
                    'poll_options': 'poll_options',
                },
                'location_map': {
                    'forum': 'query',
                    'title': 'query',
                    'post': 'query',
                    'author': 'query',
                    'author_name': 'query',
                    'prefix': 'query',
                    'tags': 'query',
                    'date': 'query',
                    'ip_address': 'query',
                    'locked': 'query',
                    'open_time': 'query',
                    'close_time': 'query',
                    'hidden': 'query',
                    'pinned': 'query',
                    'featured': 'query',
                    'poll_title': 'query',
                    'poll_public': 'query',
                    'poll_only': 'query',
                    'poll_options': 'query',
                },
                'collection_format_map': {
                    'poll_options': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def forums_topics_post(
        self,
        forum,
        title,
        post,
        author,
        **kwargs
    ):
        """Create a topic  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.forums_topics_post(forum, title, post, author, async_req=True)
        >>> result = thread.get()

        Args:
            forum (int): The ID number of the forum the topic should be created in
            title (str): The topic title
            post (str): The post content as HTML
            author (int): The ID number of the member creating the topic

        Keyword Args:
            author_name (str): The guest name to be used if author is 0. [optional]
            prefix (str): Prefix tag. [optional]
            tags (str): Comma-separated list of tags. [optional]
            date (datetime): The date/time for the topic/post post date. [optional]
            ip_address (str): The IP address for the topic/post. [optional]
            locked (int): 1/0 indicating if the topic should be locked. [optional]
            open_time (datetime): When the topic should be unlocked from. [optional]
            close_time (datetime): When the topic should be locked from. [optional]
            hidden (int): 0 = unhidden; 1 = hidden; -1 = hidden. [optional]
            pinned (int): 1/0 indicating if the topic should be pinned. [optional]
            featured (int): 1/0 indicating if the topic should be featured. [optional]
            poll_title (str): Poll title. [optional]
            poll_public (int): 1/0 indicating if the poll is public. [optional]
            poll_only (int): 1/0 indicating if this is a poll-only topic. [optional]
            poll_options ([PollOptionObject]): Array of objects with keys 'title', 'answers', and 'multichoice'. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['forum'] = \
            forum
        kwargs['title'] = \
            title
        kwargs['post'] = \
            post
        kwargs['author'] = \
            author
        return self.forums_topics_post_endpoint.call_with_http_info(**kwargs)

