# -*- coding: utf-8 -*-

"""
ipstackapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from ipstackapi.api_helper import APIHelper
from ipstackapi.configuration import Server
from ipstackapi.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from ipstackapi.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from ipstackapi.models.ip_location import IPLocation
from ipstackapi.exceptions.error_exception import ErrorException
from ipstackapi.exceptions.api_exception import APIException


class BulkIPLookupController(BaseController):

    """A Controller to access Endpoints in the ipstackapi API."""
    def __init__(self, config):
        super(BulkIPLookupController, self).__init__(config)

    def get_bulk_ip_lookup(self,
                           ips,
                           access_key,
                           hostname=None,
                           callback=None,
                           language=None,
                           fields=None,
                           output=None):
        """Does a GET request to /bulk/{ips}.

        The ipstack API offers the ability to request data for multiple IPv4
        or IPv6 addresses at the same time. 
        In order to process IP addresses in bulk, simply append multiple
        comma-separated IP addresses to the API's base URL.
        Note: Bulk IP Lookup Endpoint is only available to users who are on
        the Professional plan or above.

        Args:
            ips (str): Comma-separated list of IP addresses to lookup
            access_key (str): Your API access key
            hostname (HostnameEnum, optional): Set to 1 to see the Hostname
            callback (str, optional): Response will be wrapped inside this
                function name (JSONP)
            language (Language1Enum, optional): Set to a 2-letter language
                code to change output language. Supported languages: en
                (English/US), de (German), es (Spanish), fr (French),  ja
                (Japanese), pt-br (Portuguese Brazil), ru (Russian), zh
                (Chinese)
            fields (str, optional): Set to your preferred output field(s)
            output (OutputEnum, optional): Set to json or xml to choose
                between output formats

        Returns:
            List[IPLocation]: Response from the API. Successful bulk IP lookup

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.DEFAULT)
            .path('/bulk/{ips}')
            .http_method(HttpMethodEnum.GET)
            .template_param(Parameter()
                            .key('ips')
                            .value(ips)
                            .should_encode(True))
            .query_param(Parameter()
                         .key('access_key')
                         .value(access_key))
            .query_param(Parameter()
                         .key('hostname')
                         .value(hostname))
            .query_param(Parameter()
                         .key('callback')
                         .value(callback))
            .query_param(Parameter()
                         .key('language')
                         .value(language))
            .query_param(Parameter()
                         .key('fields')
                         .value(fields))
            .query_param(Parameter()
                         .key('output')
                         .value(output))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('apiKeyAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(IPLocation.from_dictionary)
            .local_error('400', 'Bad request', ErrorException)
            .local_error('401', 'Unauthorized - Invalid API key', ErrorException)
            .local_error('429', 'Too many requests', APIException)
            .local_error('500', 'Internal server error', APIException)
        ).execute()
