# -*- coding: utf-8 -*-

"""
ipstackapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from ipstackapi.api_helper import APIHelper


class Connection(object):

    """Implementation of the 'Connection' model.

    Attributes:
        asn (int): The ASN number
        isp (str): The ISP name

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "asn": 'asn',
        "isp": 'isp'
    }

    _optionals = [
        'asn',
        'isp',
    ]

    def __init__(self,
                 asn=APIHelper.SKIP,
                 isp=APIHelper.SKIP):
        """Constructor for the Connection class"""

        # Initialize members of the class
        if asn is not APIHelper.SKIP:
            self.asn = asn 
        if isp is not APIHelper.SKIP:
            self.isp = isp 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        asn = dictionary.get("asn") if dictionary.get("asn") else APIHelper.SKIP
        isp = dictionary.get("isp") if dictionary.get("isp") else APIHelper.SKIP
        # Return an object of this model
        return cls(asn,
                   isp)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'asn={(self.asn if hasattr(self, "asn") else None)!r}, '
                f'isp={(self.isp if hasattr(self, "isp") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'asn={(self.asn if hasattr(self, "asn") else None)!s}, '
                f'isp={(self.isp if hasattr(self, "isp") else None)!s})')
