# -*- coding: utf-8 -*-

"""
ipstackapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from ipstackapi.api_helper import APIHelper


class Currency(object):

    """Implementation of the 'Currency' model.

    Attributes:
        code (str): The currency code
        name (str): The currency name
        plural (str): The currency plural form
        symbol (str): The currency symbol
        symbol_native (str): The native currency symbol

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "code": 'code',
        "name": 'name',
        "plural": 'plural',
        "symbol": 'symbol',
        "symbol_native": 'symbol_native'
    }

    _optionals = [
        'code',
        'name',
        'plural',
        'symbol',
        'symbol_native',
    ]

    def __init__(self,
                 code=APIHelper.SKIP,
                 name=APIHelper.SKIP,
                 plural=APIHelper.SKIP,
                 symbol=APIHelper.SKIP,
                 symbol_native=APIHelper.SKIP):
        """Constructor for the Currency class"""

        # Initialize members of the class
        if code is not APIHelper.SKIP:
            self.code = code 
        if name is not APIHelper.SKIP:
            self.name = name 
        if plural is not APIHelper.SKIP:
            self.plural = plural 
        if symbol is not APIHelper.SKIP:
            self.symbol = symbol 
        if symbol_native is not APIHelper.SKIP:
            self.symbol_native = symbol_native 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        code = dictionary.get("code") if dictionary.get("code") else APIHelper.SKIP
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        plural = dictionary.get("plural") if dictionary.get("plural") else APIHelper.SKIP
        symbol = dictionary.get("symbol") if dictionary.get("symbol") else APIHelper.SKIP
        symbol_native = dictionary.get("symbol_native") if dictionary.get("symbol_native") else APIHelper.SKIP
        # Return an object of this model
        return cls(code,
                   name,
                   plural,
                   symbol,
                   symbol_native)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'code={(self.code if hasattr(self, "code") else None)!r}, '
                f'name={(self.name if hasattr(self, "name") else None)!r}, '
                f'plural={(self.plural if hasattr(self, "plural") else None)!r}, '
                f'symbol={(self.symbol if hasattr(self, "symbol") else None)!r}, '
                f'symbol_native={(self.symbol_native if hasattr(self, "symbol_native") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'code={(self.code if hasattr(self, "code") else None)!s}, '
                f'name={(self.name if hasattr(self, "name") else None)!s}, '
                f'plural={(self.plural if hasattr(self, "plural") else None)!s}, '
                f'symbol={(self.symbol if hasattr(self, "symbol") else None)!s}, '
                f'symbol_native={(self.symbol_native if hasattr(self, "symbol_native") else None)!s})')
