# -*- coding: utf-8 -*-

"""
ipstackapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from ipstackapi.api_helper import APIHelper
from ipstackapi.models.connection import Connection
from ipstackapi.models.currency import Currency
from ipstackapi.models.location import Location
from ipstackapi.models.time_zone import TimeZone


class IPLocation(object):

    """Implementation of the 'IPLocation' model.

    Attributes:
        ip (str): The IP address
        mtype (str): The type of IP address (ipv4 or ipv6)
        continent_code (str): The continent code
        continent_name (str): The continent name
        country_code (str): The country code
        country_name (str): The country name
        region_code (str): The region code
        region_name (str): The region name
        city (str): The city name
        zip (str): The ZIP code
        latitude (float): The latitude
        longitude (float): The longitude
        location (Location): The model property of type Location.
        time_zone (TimeZone): The model property of type TimeZone.
        currency (Currency): The model property of type Currency.
        connection (Connection): The model property of type Connection.
        hostname (str): The hostname (when hostname=1 parameter is used)

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "ip": 'ip',
        "mtype": 'type',
        "continent_code": 'continent_code',
        "continent_name": 'continent_name',
        "country_code": 'country_code',
        "country_name": 'country_name',
        "region_code": 'region_code',
        "region_name": 'region_name',
        "city": 'city',
        "zip": 'zip',
        "latitude": 'latitude',
        "longitude": 'longitude',
        "location": 'location',
        "time_zone": 'time_zone',
        "currency": 'currency',
        "connection": 'connection',
        "hostname": 'hostname'
    }

    _optionals = [
        'ip',
        'mtype',
        'continent_code',
        'continent_name',
        'country_code',
        'country_name',
        'region_code',
        'region_name',
        'city',
        'zip',
        'latitude',
        'longitude',
        'location',
        'time_zone',
        'currency',
        'connection',
        'hostname',
    ]

    def __init__(self,
                 ip=APIHelper.SKIP,
                 mtype=APIHelper.SKIP,
                 continent_code=APIHelper.SKIP,
                 continent_name=APIHelper.SKIP,
                 country_code=APIHelper.SKIP,
                 country_name=APIHelper.SKIP,
                 region_code=APIHelper.SKIP,
                 region_name=APIHelper.SKIP,
                 city=APIHelper.SKIP,
                 zip=APIHelper.SKIP,
                 latitude=APIHelper.SKIP,
                 longitude=APIHelper.SKIP,
                 location=APIHelper.SKIP,
                 time_zone=APIHelper.SKIP,
                 currency=APIHelper.SKIP,
                 connection=APIHelper.SKIP,
                 hostname=APIHelper.SKIP):
        """Constructor for the IPLocation class"""

        # Initialize members of the class
        if ip is not APIHelper.SKIP:
            self.ip = ip 
        if mtype is not APIHelper.SKIP:
            self.mtype = mtype 
        if continent_code is not APIHelper.SKIP:
            self.continent_code = continent_code 
        if continent_name is not APIHelper.SKIP:
            self.continent_name = continent_name 
        if country_code is not APIHelper.SKIP:
            self.country_code = country_code 
        if country_name is not APIHelper.SKIP:
            self.country_name = country_name 
        if region_code is not APIHelper.SKIP:
            self.region_code = region_code 
        if region_name is not APIHelper.SKIP:
            self.region_name = region_name 
        if city is not APIHelper.SKIP:
            self.city = city 
        if zip is not APIHelper.SKIP:
            self.zip = zip 
        if latitude is not APIHelper.SKIP:
            self.latitude = latitude 
        if longitude is not APIHelper.SKIP:
            self.longitude = longitude 
        if location is not APIHelper.SKIP:
            self.location = location 
        if time_zone is not APIHelper.SKIP:
            self.time_zone = time_zone 
        if currency is not APIHelper.SKIP:
            self.currency = currency 
        if connection is not APIHelper.SKIP:
            self.connection = connection 
        if hostname is not APIHelper.SKIP:
            self.hostname = hostname 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        ip = dictionary.get("ip") if dictionary.get("ip") else APIHelper.SKIP
        mtype = dictionary.get("type") if dictionary.get("type") else APIHelper.SKIP
        continent_code = dictionary.get("continent_code") if dictionary.get("continent_code") else APIHelper.SKIP
        continent_name = dictionary.get("continent_name") if dictionary.get("continent_name") else APIHelper.SKIP
        country_code = dictionary.get("country_code") if dictionary.get("country_code") else APIHelper.SKIP
        country_name = dictionary.get("country_name") if dictionary.get("country_name") else APIHelper.SKIP
        region_code = dictionary.get("region_code") if dictionary.get("region_code") else APIHelper.SKIP
        region_name = dictionary.get("region_name") if dictionary.get("region_name") else APIHelper.SKIP
        city = dictionary.get("city") if dictionary.get("city") else APIHelper.SKIP
        zip = dictionary.get("zip") if dictionary.get("zip") else APIHelper.SKIP
        latitude = dictionary.get("latitude") if dictionary.get("latitude") else APIHelper.SKIP
        longitude = dictionary.get("longitude") if dictionary.get("longitude") else APIHelper.SKIP
        location = Location.from_dictionary(dictionary.get('location')) if 'location' in dictionary.keys() else APIHelper.SKIP
        time_zone = TimeZone.from_dictionary(dictionary.get('time_zone')) if 'time_zone' in dictionary.keys() else APIHelper.SKIP
        currency = Currency.from_dictionary(dictionary.get('currency')) if 'currency' in dictionary.keys() else APIHelper.SKIP
        connection = Connection.from_dictionary(dictionary.get('connection')) if 'connection' in dictionary.keys() else APIHelper.SKIP
        hostname = dictionary.get("hostname") if dictionary.get("hostname") else APIHelper.SKIP
        # Return an object of this model
        return cls(ip,
                   mtype,
                   continent_code,
                   continent_name,
                   country_code,
                   country_name,
                   region_code,
                   region_name,
                   city,
                   zip,
                   latitude,
                   longitude,
                   location,
                   time_zone,
                   currency,
                   connection,
                   hostname)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'ip={(self.ip if hasattr(self, "ip") else None)!r}, '
                f'mtype={(self.mtype if hasattr(self, "mtype") else None)!r}, '
                f'continent_code={(self.continent_code if hasattr(self, "continent_code") else None)!r}, '
                f'continent_name={(self.continent_name if hasattr(self, "continent_name") else None)!r}, '
                f'country_code={(self.country_code if hasattr(self, "country_code") else None)!r}, '
                f'country_name={(self.country_name if hasattr(self, "country_name") else None)!r}, '
                f'region_code={(self.region_code if hasattr(self, "region_code") else None)!r}, '
                f'region_name={(self.region_name if hasattr(self, "region_name") else None)!r}, '
                f'city={(self.city if hasattr(self, "city") else None)!r}, '
                f'zip={(self.zip if hasattr(self, "zip") else None)!r}, '
                f'latitude={(self.latitude if hasattr(self, "latitude") else None)!r}, '
                f'longitude={(self.longitude if hasattr(self, "longitude") else None)!r}, '
                f'location={(self.location if hasattr(self, "location") else None)!r}, '
                f'time_zone={(self.time_zone if hasattr(self, "time_zone") else None)!r}, '
                f'currency={(self.currency if hasattr(self, "currency") else None)!r}, '
                f'connection={(self.connection if hasattr(self, "connection") else None)!r}, '
                f'hostname={(self.hostname if hasattr(self, "hostname") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'ip={(self.ip if hasattr(self, "ip") else None)!s}, '
                f'mtype={(self.mtype if hasattr(self, "mtype") else None)!s}, '
                f'continent_code={(self.continent_code if hasattr(self, "continent_code") else None)!s}, '
                f'continent_name={(self.continent_name if hasattr(self, "continent_name") else None)!s}, '
                f'country_code={(self.country_code if hasattr(self, "country_code") else None)!s}, '
                f'country_name={(self.country_name if hasattr(self, "country_name") else None)!s}, '
                f'region_code={(self.region_code if hasattr(self, "region_code") else None)!s}, '
                f'region_name={(self.region_name if hasattr(self, "region_name") else None)!s}, '
                f'city={(self.city if hasattr(self, "city") else None)!s}, '
                f'zip={(self.zip if hasattr(self, "zip") else None)!s}, '
                f'latitude={(self.latitude if hasattr(self, "latitude") else None)!s}, '
                f'longitude={(self.longitude if hasattr(self, "longitude") else None)!s}, '
                f'location={(self.location if hasattr(self, "location") else None)!s}, '
                f'time_zone={(self.time_zone if hasattr(self, "time_zone") else None)!s}, '
                f'currency={(self.currency if hasattr(self, "currency") else None)!s}, '
                f'connection={(self.connection if hasattr(self, "connection") else None)!s}, '
                f'hostname={(self.hostname if hasattr(self, "hostname") else None)!s})')
