# -*- coding: utf-8 -*-

"""
ipstackapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from ipstackapi.api_helper import APIHelper
from ipstackapi.configuration import Server
from ipstackapi.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from ipstackapi.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from ipstackapi.models.ip_location import IPLocation
from ipstackapi.exceptions.error_exception import ErrorException
from ipstackapi.exceptions.api_exception import APIException


class RequesterIPLookupController(BaseController):

    """A Controller to access Endpoints in the ipstackapi API."""
    def __init__(self, config):
        super(RequesterIPLookupController, self).__init__(config)

    def get_requester_ip_lookup(self,
                                access_key,
                                hostname=None,
                                callback=None,
                                language=None,
                                fields=None,
                                output=None):
        """Does a GET request to /check.

        The ipstack API also offers a separate API endpoint capable of
        detecting the IP address which the current API request is coming from. 
        In order to use this endpoint, simply append `check` to the API's base
        URL and specify your preferred optional parameters.
        Note: The Requester IP Lookup endpoint returns the details of the IP
        address from where the request is coming from. 
        For example, if you make a request from the Postman web app, it will
        show the details of the Postman server, 
        but if you make a request from the Postman client app, it will show
        the details of your computer.

        Args:
            access_key (str): Your API access key
            hostname (HostnameEnum, optional): Set to 1 to see the Hostname
            callback (str, optional): Response will be wrapped inside this
                function name (JSONP)
            language (Language1Enum, optional): Set to a 2-letter language
                code to change output language. Supported languages: en
                (English/US), de (German), es (Spanish), fr (French),  ja
                (Japanese), pt-br (Portuguese Brazil), ru (Russian), zh
                (Chinese)
            fields (str, optional): Set to your preferred output field(s)
            output (OutputEnum, optional): Set to json or xml to choose
                between output formats

        Returns:
            IPLocation: Response from the API. Successful requester IP lookup

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.DEFAULT)
            .path('/check')
            .http_method(HttpMethodEnum.GET)
            .query_param(Parameter()
                         .key('access_key')
                         .value(access_key))
            .query_param(Parameter()
                         .key('hostname')
                         .value(hostname))
            .query_param(Parameter()
                         .key('callback')
                         .value(callback))
            .query_param(Parameter()
                         .key('language')
                         .value(language))
            .query_param(Parameter()
                         .key('fields')
                         .value(fields))
            .query_param(Parameter()
                         .key('output')
                         .value(output))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('apiKeyAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(IPLocation.from_dictionary)
            .local_error('400', 'Bad request', ErrorException)
            .local_error('401', 'Unauthorized - Invalid API key', ErrorException)
            .local_error('429', 'Too many requests', APIException)
            .local_error('500', 'Internal server error', APIException)
        ).execute()
