# -*- coding: utf-8 -*-

"""
ipstackapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from ipstackapi.api_helper import APIHelper
from ipstackapi.exceptions.api_exception import APIException
from ipstackapi.models.error_1 import Error1


class ErrorException(APIException):
    def __init__(self, reason, response):
        """Constructor for the ErrorException class

        Args:
            reason (string): The reason (or error message) for the Exception
                to be raised.
            response (HttpResponse): The HttpResponse of the API call.

        """
        super(ErrorException, self).__init__(reason, response)
        dictionary = APIHelper.json_deserialize(self.response.text)
        if isinstance(dictionary, dict):
            self.unbox(dictionary)

    def unbox(self, dictionary):
        """Populates the properties of this object by extracting them from a dictionary.

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        """
        self.success = dictionary.get("success") if "success" in dictionary.keys() else None
        self.error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else None

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'success={(self.success if hasattr(self, "success") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s})')
