# -*- coding: utf-8 -*-

"""
ipstackapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from apimatic_core.configurations.global_configuration import GlobalConfiguration
from apimatic_core.decorators.lazy_property import LazyProperty
from ipstackapi.configuration import Configuration
from ipstackapi.controllers.base_controller import BaseController
from ipstackapi.configuration import Environment
from ipstackapi.http.auth.custom_query_authentication import CustomQueryAuthentication
from ipstackapi.controllers.standard_ip_lookup_controller\
    import StandardIPLookupController
from ipstackapi.controllers.bulk_ip_lookup_controller\
    import BulkIPLookupController
from ipstackapi.controllers.requester_ip_lookup_controller\
    import RequesterIPLookupController


class IpstackapiClient(object):
    @LazyProperty
    def standard_ip_lookup(self):
        return StandardIPLookupController(self.global_configuration)

    @LazyProperty
    def bulk_ip_lookup(self):
        return BulkIPLookupController(self.global_configuration)

    @LazyProperty
    def requester_ip_lookup(self):
        return RequesterIPLookupController(self.global_configuration)

    def __init__(self, http_client_instance=None,
                 override_http_client_configuration=False, http_call_back=None,
                 timeout=60, max_retries=0, backoff_factor=2,
                 retry_statuses=None, retry_methods=None,
                 environment=Environment.PRODUCTION, access_key=None,
                 custom_query_authentication_credentials=None, config=None):
        self.config = config or Configuration(
            http_client_instance=http_client_instance,
            override_http_client_configuration=override_http_client_configuration,
            http_call_back=http_call_back, timeout=timeout,
            max_retries=max_retries, backoff_factor=backoff_factor,
            retry_statuses=retry_statuses, retry_methods=retry_methods,
            environment=environment, access_key=access_key,
            custom_query_authentication_credentials=custom_query_authentication_credentials)

        self.global_configuration = GlobalConfiguration(self.config)\
            .global_errors(BaseController.global_errors())\
            .base_uri_executor(self.config.get_base_uri)\
            .user_agent(BaseController.user_agent(), BaseController.user_agent_parameters())

        self.auth_managers = {key: None for key in ['apiKeyAuth']}
        self.auth_managers['apiKeyAuth'] = CustomQueryAuthentication(
            self.config.custom_query_authentication_credentials)
        self.global_configuration = self.global_configuration.auth_managers(self.auth_managers)

