# -*- coding: utf-8 -*-

"""
ipstackapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from ipstackapi.api_helper import APIHelper


class Language(object):

    """Implementation of the 'Language' model.

    Attributes:
        code (str): The model property of type str.
        name (str): The model property of type str.
        native (str): The model property of type str.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "code": 'code',
        "name": 'name',
        "native": 'native'
    }

    _optionals = [
        'code',
        'name',
        'native',
    ]

    def __init__(self,
                 code=APIHelper.SKIP,
                 name=APIHelper.SKIP,
                 native=APIHelper.SKIP):
        """Constructor for the Language class"""

        # Initialize members of the class
        if code is not APIHelper.SKIP:
            self.code = code 
        if name is not APIHelper.SKIP:
            self.name = name 
        if native is not APIHelper.SKIP:
            self.native = native 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        code = dictionary.get("code") if dictionary.get("code") else APIHelper.SKIP
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        native = dictionary.get("native") if dictionary.get("native") else APIHelper.SKIP
        # Return an object of this model
        return cls(code,
                   name,
                   native)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'code={(self.code if hasattr(self, "code") else None)!r}, '
                f'name={(self.name if hasattr(self, "name") else None)!r}, '
                f'native={(self.native if hasattr(self, "native") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'code={(self.code if hasattr(self, "code") else None)!s}, '
                f'name={(self.name if hasattr(self, "name") else None)!s}, '
                f'native={(self.native if hasattr(self, "native") else None)!s})')
