# -*- coding: utf-8 -*-

"""
ipstackapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from ipstackapi.api_helper import APIHelper
from ipstackapi.models.language import Language


class Location(object):

    """Implementation of the 'Location' model.

    Attributes:
        geoname_id (int): The geoname ID
        capital (str): The capital city
        languages (List[Language]): The model property of type List[Language].
        country_flag (str): URL to the country flag
        country_flag_emoji (str): The country flag emoji
        country_flag_emoji_unicode (str): The country flag emoji unicode
        calling_code (str): The calling code
        is_eu (bool): Whether the country is in the EU

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "geoname_id": 'geoname_id',
        "capital": 'capital',
        "languages": 'languages',
        "country_flag": 'country_flag',
        "country_flag_emoji": 'country_flag_emoji',
        "country_flag_emoji_unicode": 'country_flag_emoji_unicode',
        "calling_code": 'calling_code',
        "is_eu": 'is_eu'
    }

    _optionals = [
        'geoname_id',
        'capital',
        'languages',
        'country_flag',
        'country_flag_emoji',
        'country_flag_emoji_unicode',
        'calling_code',
        'is_eu',
    ]

    def __init__(self,
                 geoname_id=APIHelper.SKIP,
                 capital=APIHelper.SKIP,
                 languages=APIHelper.SKIP,
                 country_flag=APIHelper.SKIP,
                 country_flag_emoji=APIHelper.SKIP,
                 country_flag_emoji_unicode=APIHelper.SKIP,
                 calling_code=APIHelper.SKIP,
                 is_eu=APIHelper.SKIP):
        """Constructor for the Location class"""

        # Initialize members of the class
        if geoname_id is not APIHelper.SKIP:
            self.geoname_id = geoname_id 
        if capital is not APIHelper.SKIP:
            self.capital = capital 
        if languages is not APIHelper.SKIP:
            self.languages = languages 
        if country_flag is not APIHelper.SKIP:
            self.country_flag = country_flag 
        if country_flag_emoji is not APIHelper.SKIP:
            self.country_flag_emoji = country_flag_emoji 
        if country_flag_emoji_unicode is not APIHelper.SKIP:
            self.country_flag_emoji_unicode = country_flag_emoji_unicode 
        if calling_code is not APIHelper.SKIP:
            self.calling_code = calling_code 
        if is_eu is not APIHelper.SKIP:
            self.is_eu = is_eu 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        geoname_id = dictionary.get("geoname_id") if dictionary.get("geoname_id") else APIHelper.SKIP
        capital = dictionary.get("capital") if dictionary.get("capital") else APIHelper.SKIP
        languages = None
        if dictionary.get('languages') is not None:
            languages = [Language.from_dictionary(x) for x in dictionary.get('languages')]
        else:
            languages = APIHelper.SKIP
        country_flag = dictionary.get("country_flag") if dictionary.get("country_flag") else APIHelper.SKIP
        country_flag_emoji = dictionary.get("country_flag_emoji") if dictionary.get("country_flag_emoji") else APIHelper.SKIP
        country_flag_emoji_unicode = dictionary.get("country_flag_emoji_unicode") if dictionary.get("country_flag_emoji_unicode") else APIHelper.SKIP
        calling_code = dictionary.get("calling_code") if dictionary.get("calling_code") else APIHelper.SKIP
        is_eu = dictionary.get("is_eu") if "is_eu" in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(geoname_id,
                   capital,
                   languages,
                   country_flag,
                   country_flag_emoji,
                   country_flag_emoji_unicode,
                   calling_code,
                   is_eu)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'geoname_id={(self.geoname_id if hasattr(self, "geoname_id") else None)!r}, '
                f'capital={(self.capital if hasattr(self, "capital") else None)!r}, '
                f'languages={(self.languages if hasattr(self, "languages") else None)!r}, '
                f'country_flag={(self.country_flag if hasattr(self, "country_flag") else None)!r}, '
                f'country_flag_emoji={(self.country_flag_emoji if hasattr(self, "country_flag_emoji") else None)!r}, '
                f'country_flag_emoji_unicode={(self.country_flag_emoji_unicode if hasattr(self, "country_flag_emoji_unicode") else None)!r}, '
                f'calling_code={(self.calling_code if hasattr(self, "calling_code") else None)!r}, '
                f'is_eu={(self.is_eu if hasattr(self, "is_eu") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'geoname_id={(self.geoname_id if hasattr(self, "geoname_id") else None)!s}, '
                f'capital={(self.capital if hasattr(self, "capital") else None)!s}, '
                f'languages={(self.languages if hasattr(self, "languages") else None)!s}, '
                f'country_flag={(self.country_flag if hasattr(self, "country_flag") else None)!s}, '
                f'country_flag_emoji={(self.country_flag_emoji if hasattr(self, "country_flag_emoji") else None)!s}, '
                f'country_flag_emoji_unicode={(self.country_flag_emoji_unicode if hasattr(self, "country_flag_emoji_unicode") else None)!s}, '
                f'calling_code={(self.calling_code if hasattr(self, "calling_code") else None)!s}, '
                f'is_eu={(self.is_eu if hasattr(self, "is_eu") else None)!s})')
