# -*- coding: utf-8 -*-

"""
ipstackapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from ipstackapi.api_helper import APIHelper


class TimeZone(object):

    """Implementation of the 'TimeZone' model.

    Attributes:
        id (str): The timezone ID
        current_time (str): The current time in the timezone
        gmt_offset (int): The GMT offset in seconds
        code (str): The timezone code
        is_daylight_saving (bool): Whether daylight saving is active

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "id": 'id',
        "current_time": 'current_time',
        "gmt_offset": 'gmt_offset',
        "code": 'code',
        "is_daylight_saving": 'is_daylight_saving'
    }

    _optionals = [
        'id',
        'current_time',
        'gmt_offset',
        'code',
        'is_daylight_saving',
    ]

    def __init__(self,
                 id=APIHelper.SKIP,
                 current_time=APIHelper.SKIP,
                 gmt_offset=APIHelper.SKIP,
                 code=APIHelper.SKIP,
                 is_daylight_saving=APIHelper.SKIP):
        """Constructor for the TimeZone class"""

        # Initialize members of the class
        if id is not APIHelper.SKIP:
            self.id = id 
        if current_time is not APIHelper.SKIP:
            self.current_time = current_time 
        if gmt_offset is not APIHelper.SKIP:
            self.gmt_offset = gmt_offset 
        if code is not APIHelper.SKIP:
            self.code = code 
        if is_daylight_saving is not APIHelper.SKIP:
            self.is_daylight_saving = is_daylight_saving 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        id = dictionary.get("id") if dictionary.get("id") else APIHelper.SKIP
        current_time = dictionary.get("current_time") if dictionary.get("current_time") else APIHelper.SKIP
        gmt_offset = dictionary.get("gmt_offset") if dictionary.get("gmt_offset") else APIHelper.SKIP
        code = dictionary.get("code") if dictionary.get("code") else APIHelper.SKIP
        is_daylight_saving = dictionary.get("is_daylight_saving") if "is_daylight_saving" in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(id,
                   current_time,
                   gmt_offset,
                   code,
                   is_daylight_saving)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'id={(self.id if hasattr(self, "id") else None)!r}, '
                f'current_time={(self.current_time if hasattr(self, "current_time") else None)!r}, '
                f'gmt_offset={(self.gmt_offset if hasattr(self, "gmt_offset") else None)!r}, '
                f'code={(self.code if hasattr(self, "code") else None)!r}, '
                f'is_daylight_saving={(self.is_daylight_saving if hasattr(self, "is_daylight_saving") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'id={(self.id if hasattr(self, "id") else None)!s}, '
                f'current_time={(self.current_time if hasattr(self, "current_time") else None)!s}, '
                f'gmt_offset={(self.gmt_offset if hasattr(self, "gmt_offset") else None)!s}, '
                f'code={(self.code if hasattr(self, "code") else None)!s}, '
                f'is_daylight_saving={(self.is_daylight_saving if hasattr(self, "is_daylight_saving") else None)!s})')
