# IPIP - 轻量化的 pip 包装器

IPIP 是一个轻量化的 pip 包装器，通过 `pyproject.toml` 管理依赖，自动使用清华镜像源，支持虚拟环境管理，让你可以像使用 `cnpm` 一样使用 `ipip`。

## 特性

- 🚀 **自动使用清华镜像源** - 无需手动配置，自动使用 `https://pypi.tuna.tsinghua.edu.cn/simple/`
- 🐍 **智能虚拟环境管理** - 自动检测并创建虚拟环境，支持已激活的环境
- 📦 **pyproject.toml 管理** - 自动更新项目依赖文件
- 🔒 **版本锁定** - 安装包时自动获取精确版本并锁定到 `pyproject.toml`
- 🧹 **智能依赖清理** - 卸载包时自动清理不再需要的依赖
- 🗑️ **自动清除 egg-info** - 安装完成后自动清除构建缓存目录
- ⚡ **轻量化** - 最小化依赖，快速安装
- 🔧 **依赖管理** - 支持安装、卸载和自动同步依赖
- 🎯 **简单易用** - 命令格式简洁明了，支持命令简写

## 使用方法

### 基本用法

```bash
# 安装包（自动创建虚拟环境和 pyproject.toml，并锁定版本）
ipip install requests

# 安装多个包
ipip install requests flask django

# 安装当前项目（相当于 pip install -e .）
ipip install

# 使用简写命令安装当前项目
ipip i

# 使用简写命令安装包
ipip i requests

# 卸载包（智能清理依赖并更新 pyproject.toml）
ipip uninstall flask

# 使用简写命令卸载包
ipip uni flask
```

### 工作流程

1. **首次使用**：
   ```bash
   # 安装第一个包，会自动创建 .venv 虚拟环境和 pyproject.toml
   ipip install requests
   # 输出：已添加 requests 版本锁定: requests==2.31.0
   # 输出：已更新 pyproject.toml 文件，包含版本锁定
   # 输出：已清除 project.egg-info
   ```

2. **继续开发**：
   ```bash
   # 安装更多依赖（自动版本锁定）
   ipip install flask sqlalchemy
   
   # 卸载不需要的包（会自动清理不再需要的依赖）
   ipip uni flask
   ```

3. **团队协作**：
   ```bash
   # 新成员克隆项目后，安装当前项目并同步所有依赖
   ipip i
   ```

### 高级用法

```bash
# 查看帮助
ipip --help

# 查看版本
ipip --version

# 查看特定命令的帮助
ipip install --help
ipip uninstall --help
```

## 命令说明

| 命令 | 简写 | 说明 | 示例 |
|------|------|------|------|
| `install` | `i` | 安装包或当前项目（自动版本锁定） | `ipip install requests` 或 `ipip i` |
| `uninstall` | `uni` | 智能卸载包并清理依赖 | `ipip uninstall flask` 或 `ipip uni flask` |

## 自动功能

### 智能虚拟环境管理
- 自动检测是否在虚拟环境中（支持已激活的环境）
- 如果不在虚拟环境中，自动创建 `.venv` 目录
- 支持 Windows 和 Unix/Linux/macOS 系统
- 避免重复创建虚拟环境

### 智能依赖管理
- 自动创建或更新 `pyproject.toml` 文件
- 安装包时自动获取精确版本并锁定到依赖列表
- 安装当前项目时自动同步所有依赖
- 卸载包时智能分析并清理不再需要的依赖
- 自动同步所有依赖，无需手动操作
- 避免误删被其他包需要的依赖

### 版本锁定功能
- 安装包后自动使用 `pip freeze` 获取精确版本
- 自动更新 `pyproject.toml` 中的依赖版本
- 支持更新已存在包的版本信息
- 确保项目依赖版本的一致性

### 自动清除构建缓存
- 安装完成后自动清除 `*.egg-info` 目录
- 支持清除 `project.egg-info`、`src/*.egg-info` 等
- 保持项目目录整洁
- 避免构建文件污染

### 依赖清理示例

```bash
# 安装 flask（会安装 flask 及其依赖，并锁定版本）
ipip install flask
# 输出：已添加 flask 版本锁定: flask==3.0.0
# 输出：已添加 blinker 版本锁定: blinker==1.7.0
# 输出：已添加 click 版本锁定: click==8.1.7
# 输出：已添加 itsdangerous 版本锁定: itsdangerous==2.1.2
# 输出：已添加 jinja2 版本锁定: jinja2==3.1.2
# 输出：已添加 markupsafe 版本锁定: markupsafe==2.1.3
# 输出：已添加 werkzeug 版本锁定: werkzeug==3.0.1
# 输出：已清除 project.egg-info

# 卸载 flask（会智能清理不再需要的依赖）
ipip uni flask
# 卸载的包：flask 及其所有依赖（如果没有其他包需要它们）
```

## 配置说明

IPIP 自动使用以下配置：

- **镜像源**: `https://pypi.tuna.tsinghua.edu.cn/simple/`
- **信任主机**: `pypi.tuna.tsinghua.edu.cn`
- **虚拟环境路径**: `.venv` (当前目录下)
- **依赖文件**: `pyproject.toml`

## 项目结构示例

使用 IPIP 后，你的项目结构会是这样：

```
my-project/
├── .venv/                    # 虚拟环境（自动创建）
├── pyproject.toml           # 项目配置和依赖（自动管理）
├── src/
│   └── my_project/
│       └── __init__.py
└── README.md
```

`pyproject.toml` 示例：
```toml
[build-system]
requires = ["setuptools>=61.0", "wheel"]
build-backend = "setuptools.build_meta"

[project]
name = "project"
version = "0.0.0"
description = ""
dependencies = [
    "requests==2.31.0",
    "flask==3.0.0",
    "werkzeug==3.0.1",
    "jinja2==3.1.2",
    "markupsafe==2.1.3",
    "itsdangerous==2.1.2",
    "click==8.1.7",
    "blinker==1.7.0"
]
```

## 技术特点

### 智能依赖分析
- 使用 `pip show` 获取包的依赖信息
- 分析包之间的依赖关系
- 智能判断哪些依赖可以安全删除
- 避免破坏其他包的依赖关系

### 版本锁定机制
- 使用 `pip freeze` 获取已安装包的精确版本
- 自动更新 `pyproject.toml` 中的版本信息
- 支持检测和更新已存在包的版本
- 确保项目依赖版本的一致性

### 虚拟环境检测
- 多重检测机制确保准确性
- 支持标准虚拟环境检测
- 支持 `.venv` 目录检测
- 避免重复创建虚拟环境

### 构建缓存清理
- 自动检测和清除 `egg-info` 目录
- 支持多种 `egg-info` 目录模式
- 保持项目目录整洁
- 智能错误处理

### 错误处理
- 完善的异常处理机制
- 用户友好的错误提示
- 优雅的失败恢复
- 详细的调试信息

## 开发

### 项目结构

```
ipip/
├── __init__.py      # 包初始化
├── cli.py          # 命令行接口
├── dptree.py       # 依赖树分析模块
├── pyproject.toml  # 项目配置
└── README.md       # 说明文档
```

### 本地开发

```bash
# 克隆项目
git clone <repository-url>
cd ipip

# 安装开发依赖
pip install -e .

# 测试功能
ipip install requests
ipip uninstall requests
ipip install  # 安装当前项目
```

## 许可证

MIT License

## 贡献

欢迎提交 Issue 和 Pull Request！

## 更新日志

### v0.0.0
- 支持通过 pyproject.toml 管理依赖
- 智能虚拟环境检测和创建
- 支持 install、uninstall 命令及其简写形式
- 支持 install 和 i 命令安装当前项目
- 智能依赖清理功能
- 自动版本锁定功能
- 自动清除 egg-info 目录
- 自动使用清华镜像源
- 改进的虚拟环境检测机制
- 智能依赖分析和清理
- 完善的错误处理机制 