#!/usr/bin/env python3
"""
IPIP 安装脚本
"""

from setuptools import setup, find_packages
import os

# 读取 README 文件
def read_readme():
    with open("README.md", "r", encoding="utf-8") as fh:
        return fh.read()

# 读取 requirements 文件
def read_requirements():
    if os.path.exists("requirements.txt"):
        with open("requirements.txt", "r", encoding="utf-8") as fh:
            return [line.strip() for line in fh if line.strip() and not line.startswith("#")]
    return []

setup(
    name="ipip",
    version="0.0.0",
    author="MoYuStudio",
    author_email="cpip@example.com",
    description="轻量化的 pip 包装器，自动使用清华镜像源安装包",
    long_description=read_readme(),
    long_description_content_type="text/markdown",
    url="https://github.com/cpip-team/cpip",
    project_urls={
        "Bug Reports": "https://github.com/cpip-team/cpip/issues",
        "Source": "https://github.com/cpip-team/cpip",
        "Documentation": "https://github.com/cpip-team/cpip#readme",
    },
    packages=find_packages(),
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Programming Language :: Python :: 3.13",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: System :: Systems Administration",
        "Topic :: Utilities",
    ],
    install_requires=read_requirements(),
    entry_points={
        "console_scripts": [
            "cpip=cpip.cli:main",
        ],
    },
    keywords="pip, package-manager, tsinghua-mirror, cnpm-like",
    zip_safe=False,
    include_package_data=True,
) 