
import setuptools

with open("README.md", "r", encoding='utf-8') as fh:
   long_description = fh.read()

setuptools.setup(
   name="is3_python_sdk",
   version="1.0.7",
   author="chaser",
   author_email="sxing.liu@foxmail.com",
   description="is3 python kafka server",
   long_description=long_description,
   long_description_content_type="text/markdown",
   packages=setuptools.find_packages(),
   install_requires=[
        'altgraph==0.17.4',
        'annotated-types==0.7.0',
        'argon2-cffi==23.1.0',
        'argon2-cffi-bindings==21.2.0',
        'asttokens==2.4.1',
        'async-timeout==4.0.3',
        'attrs==23.2.0',
        'autoflake==2.3.1',
        'backports.tarfile==1.2.0',
        'blinker==1.8.2',
        'build==1.2.1',
        'bump2version==1.0.1',
        'bumpversion2==1.4.1',
        'certifi==2024.2.2',
        'cffi==1.16.0',
        'chardet==5.2.0',
        'charset-normalizer==3.3.2',
        'click==8.1.7',
        'colorama==0.4.6',
        'colorlog==6.8.2',
        'comm==0.2.2',
        'ConfigArgParse==1.7',
        'confluent-kafka==2.3.0',
        'contourpy==1.2.0',
        'coverage==7.6.1',
        'cycler==0.12.1',
        'dash==2.17.1',
        'dash-core-components==2.0.0',
        'dash-html-components==2.0.0',
        'dash-table==5.0.0',
        'debugpy==1.8.1',
        'decorator==5.1.1',
        'distlib==0.3.8',
        'docutils==0.21.2',
        'et-xmlfile==1.1.0',
        'exceptiongroup==1.2.0',
        'executing==2.0.1',
        'fastjsonschema==2.20.0',
        'filelock==3.13.3',
        'flasgger==0.9.7.1',
        'Flask==3.0.3',
        'fonttools==4.50.0',
        'gunicorn==21.2.0',
        'idna==3.6',
        'importlib_metadata==7.1.0',
        'iniconfig==2.0.0',
        'ipykernel==6.29.4',
        'ipython==8.23.0',
        'ipywidgets==8.1.3',
        'is3_python_sdk==1.0.6',
        'itsdangerous==2.2.0',
        'jaraco.classes==3.4.0',
        'jaraco.context==5.3.0',
        'jaraco.functools==4.0.1',
        'jedi==0.19.1',
        'Jinja2==3.1.4',
        'joblib==1.4.2',
        'jsonschema==4.22.0',
        'jsonschema-specifications==2023.12.1',
        'jupyter_client==8.6.1',
        'jupyter_core==5.7.2',
        'jupyterlab_widgets==3.0.11',
        'keyring==25.2.1',
        'kiwisolver==1.4.5',
        'laspy==2.5.4',
        'markdown-it-py==3.0.0',
        'MarkupSafe==2.1.5',
        'matplotlib==3.8.3',
        'matplotlib-inline==0.1.6',
        'mdurl==0.1.2',
        'minio==7.2.5',
        'mistune==3.0.2',
        'more-itertools==10.3.0',
        'mypy==1.11.1',
        'mypy-extensions==1.0.0',
        'nacos-sdk-python==0.1.7',
        'nacos-sdk-python-is3==0.1.15',
        'nbformat==5.10.4',
        'nest-asyncio==1.6.0',
        'nh3==0.2.17',
        'numpy==1.26.4',
        'open3d==0.18.0',
        'opencv-python==4.9.0.80',
        'openpyxl==3.1.2',
        'packaging==24.0',
        'pandas==2.2.1',
        'parso==0.8.4',
        'pefile==2023.2.7',
        'pillow==10.2.0',
        'pkginfo==1.11.1',
        'platformdirs==4.2.0',
        'plotly==5.23.0',
        'pluggy==1.5.0',
        'prompt-toolkit==3.0.43',
        'psutil==5.9.8',
        'pure-eval==0.2.2',
        'py==1.11.0',
        'pycparser==2.21',
        'pycryptodome==3.20.0',
        'pydantic==2.8.2',
        'pydantic_core==2.20.1',
        'pyflakes==3.2.0',
        'Pygments==2.17.2',
        'pyinstaller==6.10.0',
        'pyinstaller-hooks-contrib==2024.8',
        'pyparsing==3.1.2',
        'pyproject_hooks==1.1.0',
        'python-dateutil==2.9.0.post0',
        'pytz==2024.1',
        'pywin32==306',
        'pywin32-ctypes==0.2.2',
        'PyYAML==6.0.1',
        'pyzmq==25.1.2',
        'readme_renderer==43.0',
        'redis==5.0.3',
        'referencing==0.35.1',
        'requests==2.32.3',
        'requests-toolbelt==1.0.0',
        'retry==0.9.2',
        'retrying==1.3.4',
        'rfc3986==2.0.0',
        'rich==13.7.1',
        'rpds-py==0.18.1',
        'ruff==0.5.7',
        'scikit-learn==1.5.1',
        'scipy==1.14.0',
        'shellingham==1.5.4',
        'six==1.16.0',
        'snowflake-id==1.0.1',
        'stack-data==0.6.3',
        'tenacity==9.0.0',
        'threadpoolctl==3.5.0',
        'tomli==2.0.1',
        'tornado==6.4',
        'traitlets==5.14.2',
        'twine==5.1.0',
        'typer==0.12.3',
        'typing_extensions==4.10.0',
        'tzdata==2024.1',
        'urllib3==2.2.1',
        'virtualenv==20.25.1',
        'wcwidth==0.2.13',
        'Werkzeug==3.0.3',
        'widgetsnbextension==4.0.11',
        'yapf==0.40.2',
        'zipp==3.18.1',
    ],
   entry_points={
       'console_scripts': [
           'is3_run_app=app:main'
       ],
   },
   classifiers=(
       "Programming Language :: Python :: 3",
       "License :: OSI Approved :: MIT License",
       "Operating System :: OS Independent",
   ),
   include_package_data=True,
)
