from enum import Enum


class SQLState(Enum):
    NoData = "02000"
    NoAdditionalDynamicResultSetsReturned = "02001"
    SqlStatementNotYetComplete = "03000"
    ConnectionException = "08000"
    SqlclientUnableToEstablishSqlconnection = "08001"
    ConnectionDoesNotExist = "08003"
    SqlserverRejectedEstablishmentOfSqlconnection = "08004"
    ConnectionFailure = "08006"
    TransactionResolutionUnknown = "08007"
    ProtocolViolation = "08P01"
    TriggeredActionException = "09000"
    FeatureNotSupported = "0A000"
    InvalidTransactionInitiation = "0B000"
    LocatorException = "0F000"
    InvalidLocatorSpecification = "0F001"
    InvalidGrantor = "0L000"
    InvalidGrantOperation = "0LP01"
    InvalidRoleSpecification = "0P000"
    DiagnosticsException = "0Z000"
    StackedDiagnosticsAccessedWithoutActiveHandler = "0Z002"
    CaseNotFound = "20000"
    CardinalityViolation = "21000"
    DataException = "22000"
    StringDataRightTruncation = "22001"
    NullValueNoIndicatorParameter = "22002"
    NumericValueOutOfRange = "22003"
    NullValueNotAllowed = "22004"
    ErrorInAssignment = "22005"
    InvalidDatetimeFormat = "22007"
    DatetimeFieldOverflow = "22008"
    InvalidTimeZoneDisplacementValue = "22009"
    EscapeCharacterConflict = "2200B"
    InvalidUseOfEscapeCharacter = "2200C"
    InvalidEscapeOctet = "2200D"
    ZeroLengthCharacterString = "2200F"
    MostSpecificTypeMismatch = "2200G"
    SequenceGeneratorLimitExceeded = "2200H"
    NotAnXmlDocument = "2200L"
    InvalidXmlDocument = "2200M"
    InvalidXmlContent = "2200N"
    InvalidXmlComment = "2200S"
    InvalidXmlProcessingInstruction = "2200T"
    InvalidIndicatorParameterValue = "22010"
    SubstringError = "22011"
    DivisionByZero = "22012"
    InvalidPrecedingOrFollowingSize = "22013"
    InvalidArgumentForNtileFunction = "22014"
    IntervalFieldOverflow = "22015"
    InvalidArgumentForNthValueFunction = "22016"
    InvalidCharacterValueForCast = "22018"
    InvalidEscapeCharacter = "22019"
    InvalidRegularExpression = "2201B"
    InvalidArgumentForLogarithm = "2201E"
    InvalidArgumentForPowerFunction = "2201F"
    InvalidArgumentForWidthBucketFunction = "2201G"
    InvalidRowCountInLimitClause = "2201W"
    InvalidRowCountInResultOffsetClause = "2201X"
    CharacterNotInRepertoire = "22021"
    IndicatorOverflow = "22022"
    InvalidParameterValue = "22023"
    UnterminatedCString = "22024"
    InvalidEscapeSequence = "22025"
    StringDataLengthMismatch = "22026"
    TrimError = "22027"
    ArraySubscriptError = "2202E"
    InvalidTablesampleRepeat = "2202G"
    InvalidTablesampleArgument = "2202H"
    DuplicateJsonObjectKeyValue = "22030"
    InvalidArgumentForSqlJsonDatetimeFunction = "22031"
    InvalidJsonText = "22032"
    InvalidSqlJsonSubscript = "22033"
    MoreThanOneSqlJsonItem = "22034"
    NoSqlJsonItem = "22035"
    NonNumericSqlJsonItem = "22036"
    NonUniqueKeysInAJsonObject = "22037"
    SingletonSqlJsonItemRequired = "22038"
    SqlJsonArrayNotFound = "22039"
    SqlJsonMemberNotFound = "2203A"
    SqlJsonNumberNotFound = "2203B"
    SqlJsonObjectNotFound = "2203C"
    TooManyJsonArrayElements = "2203D"
    TooManyJsonObjectMembers = "2203E"
    SqlJsonScalarRequired = "2203F"
    SqlJsonItemCannotBeCastToTargetType = "2203G"
    FloatingPointException = "22P01"
    InvalidTextRepresentation = "22P02"
    InvalidBinaryRepresentation = "22P03"
    BadCopyFileFormat = "22P04"
    UntranslatableCharacter = "22P05"
    NonstandardUseOfEscapeCharacter = "22P06"
    IntegrityConstraintViolation = "23000"
    RestrictViolation = "23001"
    NotNullViolation = "23502"
    ForeignKeyViolation = "23503"
    UniqueViolation = "23505"
    CheckViolation = "23514"
    ExclusionViolation = "23P01"
    InvalidCursorState = "24000"
    InvalidTransactionState = "25000"
    ActiveSqlTransaction = "25001"
    BranchTransactionAlreadyActive = "25002"
    InappropriateAccessModeForBranchTransaction = "25003"
    InappropriateIsolationLevelForBranchTransaction = "25004"
    NoActiveSqlTransactionForBranchTransaction = "25005"
    ReadOnlySqlTransaction = "25006"
    SchemaAndDataStatementMixingNotSupported = "25007"
    HeldCursorRequiresSameIsolationLevel = "25008"
    NoActiveSqlTransaction = "25P01"
    InFailedSqlTransaction = "25P02"
    IdleInTransactionSessionTimeout = "25P03"
    InvalidSqlStatementName = "26000"
    TriggeredDataChangeViolation = "27000"
    InvalidAuthorizationSpecification = "28000"
    InvalidPassword = "28P01"
    DependentPrivilegeDescriptorsStillExist = "2B000"
    DependentObjectsStillExist = "2BP01"
    InvalidTransactionTermination = "2D000"
    SqlRoutineException = "2F000"
    ModifyingSqlDataNotPermitted = "2F002"
    ProhibitedSqlStatementAttempted = "2F003"
    ReadingSqlDataNotPermitted = "2F004"
    FunctionExecutedNoReturnStatement = "2F005"
    InvalidCursorName = "34000"
    ExternalRoutineException = "38000"
    ContainingSqlNotPermitted = "38001"
    ModifyingSqlDataNotPermittedExt = "38002"
    ProhibitedSqlStatementAttemptedExt = "38003"
    ReadingSqlDataNotPermittedExt = "38004"
    ExternalRoutineInvocationException = "39000"
    InvalidSqlstateReturned = "39001"
    NullValueNotAllowedExt = "39004"
    TriggerProtocolViolated = "39P01"
    SrfProtocolViolated = "39P02"
    EventTriggerProtocolViolated = "39P03"
    SavepointException = "3B000"
    InvalidSavepointSpecification = "3B001"
    InvalidCatalogName = "3D000"
    InvalidSchemaName = "3F000"
    TransactionRollback = "40000"
    SerializationFailure = "40001"
    TransactionIntegrityConstraintViolation = "40002"
    StatementCompletionUnknown = "40003"
    DeadlockDetected = "40P01"
    SyntaxErrorOrAccessRuleViolation = "42000"
    InsufficientPrivilege = "42501"
    SyntaxError = "42601"
    InvalidName = "42602"
    InvalidColumnDefinition = "42611"
    NameTooLong = "42622"
    DuplicateColumn = "42701"
    AmbiguousColumn = "42702"
    UndefinedColumn = "42703"
    UndefinedObject = "42704"
    DuplicateObject = "42710"
    DuplicateAlias = "42712"
    DuplicateFunction = "42723"
    AmbiguousFunction = "42725"
    GroupingError = "42803"
    DatatypeMismatch = "42804"
    WrongObjectType = "42809"
    InvalidForeignKey = "42830"
    CannotCoerce = "42846"
    UndefinedFunction = "42883"
    GeneratedAlways = "428C9"
    ReservedName = "42939"
    UndefinedTable = "42P01"
    UndefinedParameter = "42P02"
    DuplicateCursor = "42P03"
    DuplicateDatabase = "42P04"
    DuplicatePreparedStatement = "42P05"
    DuplicateSchema = "42P06"
    DuplicateTable = "42P07"
    AmbiguousParameter = "42P08"
    AmbiguousAlias = "42P09"
    InvalidColumnReference = "42P10"
    InvalidCursorDefinition = "42P11"
    InvalidDatabaseDefinition = "42P12"
    InvalidFunctionDefinition = "42P13"
    InvalidPreparedStatementDefinition = "42P14"
    InvalidSchemaDefinition = "42P15"
    InvalidTableDefinition = "42P16"
    InvalidObjectDefinition = "42P17"
    IndeterminateDatatype = "42P18"
    InvalidRecursion = "42P19"
    WindowingError = "42P20"
    CollationMismatch = "42P21"
    IndeterminateCollation = "42P22"
    WithCheckOptionViolation = "44000"
    InsufficientResources = "53000"
    DiskFull = "53100"
    OutOfMemory = "53200"
    TooManyConnections = "53300"
    ConfigurationLimitExceeded = "53400"
    ProgramLimitExceeded = "54000"
    StatementTooComplex = "54001"
    TooManyColumns = "54011"
    TooManyArguments = "54023"
    ObjectNotInPrerequisiteState = "55000"
    ObjectInUse = "55006"
    CantChangeRuntimeParam = "55P02"
    LockNotAvailable = "55P03"
    UnsafeNewEnumValueUsage = "55P04"
    OperatorIntervention = "57000"
    QueryCanceled = "57014"
    AdminShutdown = "57P01"
    CrashShutdown = "57P02"
    CannotConnectNow = "57P03"
    DatabaseDropped = "57P04"
    IdleSessionTimeout = "57P05"
    SystemError = "58000"
    IoError = "58030"
    UndefinedFile = "58P01"
    DuplicateFile = "58P02"
    SnapshotTooOld = "72000"
    ConfigFileError = "F0000"
    LockFileExists = "F0001"
    FdwError = "HV000"
    FdwOutOfMemory = "HV001"
    FdwDynamicParameterValueNeeded = "HV002"
    FdwInvalidDataType = "HV004"
    FdwColumnNameNotFound = "HV005"
    FdwInvalidDataTypeDescriptors = "HV006"
    FdwInvalidColumnName = "HV007"
    FdwInvalidColumnNumber = "HV008"
    FdwInvalidUseOfNullPointer = "HV009"
    FdwInvalidStringFormat = "HV00A"
    FdwInvalidHandle = "HV00B"
    FdwInvalidOptionIndex = "HV00C"
    FdwInvalidOptionName = "HV00D"
    FdwOptionNameNotFound = "HV00J"
    FdwReplyHandle = "HV00K"
    FdwUnableToCreateExecution = "HV00L"
    FdwUnableToCreateReply = "HV00M"
    FdwUnableToEstablishConnection = "HV00N"
    FdwNoSchemas = "HV00P"
    FdwSchemaNotFound = "HV00Q"
    FdwTableNotFound = "HV00R"
    FdwFunctionSequenceError = "HV010"
    FdwTooManyHandles = "HV014"
    FdwInconsistentDescriptorInformation = "HV021"
    FdwInvalidAttributeValue = "HV024"
    FdwInvalidStringLengthOrBufferLength = "HV090"
    FdwInvalidDescriptorFieldIdentifier = "HV091"
    PlpgsqlError = "P0000"
    RaiseException = "P0001"
    NoDataFound = "P0002"
    TooManyRows = "P0003"
    AssertFailure = "P0004"
    InternalError_ = "XX000"
    DataCorrupted = "XX001"


class Constraints(Enum):
    ApplicationNameKey = "application_name_key"
    ApplicationSchemaApplicationNameKey = "application_schema_application_name_key"
    EmailDispatcherApplicationNameKey = "email_dispatcher_application_name_key"
    PgReservedWordTextKey = "pg__reserved_word_text_key"
    EmailTemplateApplicationNameKey = "email_template_application_name_key"
    DocumentTemplateApplicationNameKey = "document_template_application_name_key"
    DocumentRequestUuidKey = "document_request_uuid_key"
    AccountIdKey = "account_id_key"
    AccountPasswordUuidKey = "account_password_uuid_key"
    ValidatedIpAddressUuidKey = "validated_ip_address_uuid_key"
    SecurityEventApplicationEventLockKey = "security_event_application_event_lock_key"
    HandledErrorCodeKey = "handled_error_code_key"
    PgBaseExceptionNameKey = "pg_base_exception_name_key"
    PgErrorClassCodeKey = "pg_error_class_code_key"
    PgExceptionSqlstateKey = "pg_exception_sqlstate_key"
    RemoteProcedureApplicationNameKey = "remote_procedure_application_name_key"
    AccountUsernameKey = "account_username_key"
    AccountPasswordHashKey = "account_password_hash_key"
    ValidatedIpAddressEncryptedSaltedIpAddressKey = "validated_ip_address_encrypted_salted_ip_address_key"


RESPONSE_CODE_LOOKUP = {
    1001: 422,
    1002: 422,
    1003: 422,
    1004: 422,
    1005: 422,
    1006: 422,
    1007: 422,
    1008: 422,
    1009: 401,
    1010: 500,
    1011: 422,
    1012: 422,
    1013: 422,
    1014: 422,
    1015: 422,
    1016: 422,
    1017: 422,
    1018: 422,
    1019: 422,
    1020: 422,
    1021: 422,
    1022: 422,
    1023: 500
}