# Autogenerated file. Do not edit.
from jacdac.bus import Bus, Client, EventHandlerFn, UnsubscribeFn
from .constants import *
from typing import Optional, Tuple


class VerifiedTelemetryClient(Client):
    """
    A mixin service that exposes verified telemetry information for a sensor (see https://github.com/Azure/Verified-Telemetry/tree/main/PnPModel).
    Implements a client for the `Verified Telemetry <https://microsoft.github.io/jacdac-docs/services/verifiedtelemetrysensor>`_ service.
    """

    def __init__(self, bus: Bus, role: str) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_VERIFIED_TELEMETRY, JD_VERIFIED_TELEMETRY_PACK_FORMATS, role)
    

    @property
    def telemetry_status(self) -> Optional[VerifiedTelemetryStatus]:
        """
        Reads the telemetry working status, where ``true`` is working and ``false`` is faulty., 
        """
        return self.register(JD_VERIFIED_TELEMETRY_REG_TELEMETRY_STATUS).value()

    @property
    def telemetry_status_interval(self) -> Optional[int]:
        """
        (Optional) Specifies the interval between computing the fingerprint information., _: ms
        """
        return self.register(JD_VERIFIED_TELEMETRY_REG_TELEMETRY_STATUS_INTERVAL).value()

    @telemetry_status_interval.setter
    def telemetry_status_interval(self, value: int) -> None:
        self.register(JD_VERIFIED_TELEMETRY_REG_TELEMETRY_STATUS_INTERVAL).set_values(value)


    @property
    def fingerprint_type(self) -> Optional[VerifiedTelemetryFingerprintType]:
        """
        Type of the fingerprint., 
        """
        return self.register(JD_VERIFIED_TELEMETRY_REG_FINGERPRINT_TYPE).value()

    @property
    def fingerprint_template(self) -> Optional[Tuple[int, bytes]]:
        """
        Template Fingerprint information of a working sensor., confidence: %
        """
        return self.register(JD_VERIFIED_TELEMETRY_REG_FINGERPRINT_TEMPLATE).value()

    def on_telemetry_status_change(self, handler: EventHandlerFn) -> UnsubscribeFn:
        """
        The telemetry status of the device was updated.
        """
        return self.on_event(JD_VERIFIED_TELEMETRY_EV_TELEMETRY_STATUS_CHANGE, handler)

    def on_fingerprint_template_change(self, handler: EventHandlerFn) -> UnsubscribeFn:
        """
        The fingerprint template was updated
        """
        return self.on_event(JD_VERIFIED_TELEMETRY_EV_FINGERPRINT_TEMPLATE_CHANGE, handler)


    def reset_fingerprint_template(self, ) -> None:
        """
        This command will clear the template fingerprint of a sensor and collect a new template fingerprint of the attached sensor.
        """
        self.send_cmd_packed(JD_VERIFIED_TELEMETRY_CMD_RESET_FINGERPRINT_TEMPLATE, )

    def retrain_fingerprint_template(self, ) -> None:
        """
        This command will append a new template fingerprint to the `fingerprintTemplate`. Appending more fingerprints will increase the accuracy in detecting the telemetry status.
        """
        self.send_cmd_packed(JD_VERIFIED_TELEMETRY_CMD_RETRAIN_FINGERPRINT_TEMPLATE, )
    
