# Autogenerated file. Do not edit.
from jacdac.bus import Bus, SensorClient
from .constants import *
from typing import Optional


class WindDirectionClient(SensorClient):
    """
    A sensor that measures wind direction.
    Implements a client for the `Wind direction <https://microsoft.github.io/jacdac-docs/services/winddirection>`_ service.
    """

    def __init__(self, bus: Bus, role: str) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_WIND_DIRECTION, JD_WIND_DIRECTION_PACK_FORMATS, role, preferred_interval = 1000)
    

    @property
    def wind_direction(self) -> Optional[int]:
        """
        The direction of the wind., _: °
        """
        self.refresh_reading()
        return self.register(JD_WIND_DIRECTION_REG_WIND_DIRECTION).value()

    @property
    def wind_direction_error(self) -> Optional[int]:
        """
        (Optional) Error on the wind direction reading, _: °
        """
        return self.register(JD_WIND_DIRECTION_REG_WIND_DIRECTION_ERROR).value()

    
