# Autogenerated file. Do not edit.
from jacdac.bus import Bus, Client
from .constants import *
from typing import Optional


class ArcadeSoundClient(Client):
    """
    A sound playing device.
     * 
     * This is typically run over an SPI connection, not regular single-wire JACDAC.
    Implements a client for the `Arcade Sound <https://microsoft.github.io/jacdac-docs/services/arcadesound>`_ service.
    """

    def __init__(self, bus: Bus, role: str) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_ARCADE_SOUND, JD_ARCADE_SOUND_PACK_FORMATS, role)
    

    @property
    def sample_rate(self) -> Optional[float]:
        """
        Get or set playback sample rate (in samples per second).
        If you set it, read it back, as the value may be rounded up or down., _: Hz
        """
        return self.register(JD_ARCADE_SOUND_REG_SAMPLE_RATE).value()

    @sample_rate.setter
    def sample_rate(self, value: float) -> None:
        self.register(JD_ARCADE_SOUND_REG_SAMPLE_RATE).set_values(value)


    @property
    def buffer_size(self) -> Optional[int]:
        """
        The size of the internal audio buffer., _: B
        """
        return self.register(JD_ARCADE_SOUND_REG_BUFFER_SIZE).value()

    @property
    def buffer_pending(self) -> Optional[int]:
        """
        How much data is still left in the buffer to play.
        Clients should not send more data than `buffer_size - buffer_pending`,
        but can keep the `buffer_pending` as low as they want to ensure low latency
        of audio playback., _: B
        """
        return self.register(JD_ARCADE_SOUND_REG_BUFFER_PENDING).value()


    def play(self, samples: bytes) -> None:
        """
        Play samples, which are single channel, signed 16-bit little endian values.
        """
        self.send_cmd_packed(JD_ARCADE_SOUND_CMD_PLAY, samples)
    
