# Autogenerated file. Do not edit.
from jacdac.bus import Bus, Client
from .constants import *



class HidKeyboardClient(Client):
    """
    Control a HID keyboard. 
     * 
     * The codes for the key (selectors) is defined in the [HID Keyboard
     * specification](https://usb.org/sites/default/files/hut1_21.pdf), chapter 10 Keyboard/Keypad Page, page 81.
     * Modifiers are in page 87.
     * 
     * The device keeps tracks of the key state and is able to clear it all with the clear command.
    Implements a client for the `HID Keyboard <https://microsoft.github.io/jacdac-docs/services/hidkeyboard>`_ service.
    """

    def __init__(self, bus: Bus, role: str) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_HID_KEYBOARD, JD_HID_KEYBOARD_PACK_FORMATS, role)
    


    def clear(self, ) -> None:
        """
        Clears all pressed keys.
        """
        self.send_cmd_packed(JD_HID_KEYBOARD_CMD_CLEAR, )
    
