# Autogenerated file. Do not edit.
from jacdac.bus import Bus, Client, EventHandlerFn, UnsubscribeFn
from .constants import *
from typing import Optional


class MatrixKeypadClient(Client):
    """
    A matrix of buttons connected as a keypad
    Implements a client for the `Matrix Keypad <https://microsoft.github.io/jacdac-docs/services/matrixkeypad>`_ service.
    """

    def __init__(self, bus: Bus, role: str) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_MATRIX_KEYPAD, JD_MATRIX_KEYPAD_PACK_FORMATS, role)
    

    @property
    def rows(self) -> Optional[int]:
        """
        Number of rows in the matrix, _: #
        """
        return self.register(JD_MATRIX_KEYPAD_REG_ROWS).value()

    @property
    def columns(self) -> Optional[int]:
        """
        Number of columns in the matrix, _: #
        """
        return self.register(JD_MATRIX_KEYPAD_REG_COLUMNS).value()

    @property
    def variant(self) -> Optional[MatrixKeypadVariant]:
        """
        (Optional) The type of physical keypad. If the variant is ``ElastomerLEDPixel``
        and the next service on the device is a ``LEDPixel`` service, it is considered
        as the service controlling the LED pixel on the keypad., 
        """
        return self.register(JD_MATRIX_KEYPAD_REG_VARIANT).value()

    def on_down(self, handler: EventHandlerFn) -> UnsubscribeFn:
        """
        Emitted when a key, at the given index, goes from inactive (`pressed == 0`) to active.
        """
        return self.on_event(JD_MATRIX_KEYPAD_EV_DOWN, handler)

    def on_up(self, handler: EventHandlerFn) -> UnsubscribeFn:
        """
        Emitted when a key, at the given index, goes from active (`pressed == 1`) to inactive.
        """
        return self.on_event(JD_MATRIX_KEYPAD_EV_UP, handler)

    def on_click(self, handler: EventHandlerFn) -> UnsubscribeFn:
        """
        Emitted together with `up` when the press time was not longer than 500ms.
        """
        return self.on_event(JD_MATRIX_KEYPAD_EV_CLICK, handler)

    def on_long_click(self, handler: EventHandlerFn) -> UnsubscribeFn:
        """
        Emitted together with `up` when the press time was more than 500ms.
        """
        return self.on_event(JD_MATRIX_KEYPAD_EV_LONG_CLICK, handler)

    
