# Autogenerated file. Do not edit.
from jacdac.bus import Bus, Client, EventHandlerFn, UnsubscribeFn
from .constants import *



class MultitouchClient(Client):
    """
    A capacitive touch sensor with multiple inputs.
    Implements a client for the `Multitouch <https://microsoft.github.io/jacdac-docs/services/multitouch>`_ service.
    """

    def __init__(self, bus: Bus, role: str) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_MULTITOUCH, JD_MULTITOUCH_PACK_FORMATS, role)
    

    def on_touch(self, handler: EventHandlerFn) -> UnsubscribeFn:
        """
        Emitted when an input is touched.
        """
        return self.on_event(JD_MULTITOUCH_EV_TOUCH, handler)

    def on_release(self, handler: EventHandlerFn) -> UnsubscribeFn:
        """
        Emitted when an input is no longer touched.
        """
        return self.on_event(JD_MULTITOUCH_EV_RELEASE, handler)

    def on_tap(self, handler: EventHandlerFn) -> UnsubscribeFn:
        """
        Emitted when an input is briefly touched. TODO Not implemented.
        """
        return self.on_event(JD_MULTITOUCH_EV_TAP, handler)

    def on_long_press(self, handler: EventHandlerFn) -> UnsubscribeFn:
        """
        Emitted when an input is touched for longer than 500ms. TODO Not implemented.
        """
        return self.on_event(JD_MULTITOUCH_EV_LONG_PRESS, handler)

    def on_swipe_pos(self, handler: EventHandlerFn) -> UnsubscribeFn:
        """
        Emitted when input channels are successively touched in order of increasing channel numbers.
        """
        return self.on_event(JD_MULTITOUCH_EV_SWIPE_POS, handler)

    def on_swipe_neg(self, handler: EventHandlerFn) -> UnsubscribeFn:
        """
        Emitted when input channels are successively touched in order of decreasing channel numbers.
        """
        return self.on_event(JD_MULTITOUCH_EV_SWIPE_NEG, handler)

    
