# Autogenerated file. Do not edit.
from jacdac.bus import Bus, Client, EventHandlerFn, UnsubscribeFn
from .constants import *
from typing import Optional


class RoleManagerClient(Client):
    """
    Assign roles to services on the Jacdac bus.
     * 
     * Internally, the role manager stores a mapping from `(device_id, service_idx)` to role name.
     * Users refer to services by using role names (eg., they instantiate an accelerometer client with a given role name).
     * Each client has a role, and roles are unique to clients
     * (ie., one should not have both a gyro and accelerometer service with role `left_leg`).
     * 
     * Role names can be hierarchical, using slash character as a separator.
     * Examples: `left_leg/acc`, `left_leg/gyro`, `right_leg/acc`.
     * If two roles share the prefix before first slash, it should be used as a hint that the services
     * should be co-located on a single device
     * (eg., here the `left_leg` "location" is expected to have both an accelerometer and a gyro service on a single device).
    Implements a client for the `Role Manager <https://microsoft.github.io/jacdac-docs/services/rolemanager>`_ service.
    """

    def __init__(self, bus: Bus, role: str) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_ROLE_MANAGER, JD_ROLE_MANAGER_PACK_FORMATS, role)
    

    @property
    def auto_bind(self) -> Optional[bool]:
        """
        Normally, if some roles are unfilled, and there are idle services that can fulfill them,
        the brain device will assign roles (bind) automatically.
        Such automatic assignment happens every second or so, and is trying to be smart about 
        co-locating roles that share "host" (part before first slash),
        as well as reasonably stable assignments.
        Once user start assigning roles manually using this service, auto-binding should be disabled to avoid confusion., 
        """
        return self.register(JD_ROLE_MANAGER_REG_AUTO_BIND).bool_value()

    @auto_bind.setter
    def auto_bind(self, value: bool) -> None:
        self.register(JD_ROLE_MANAGER_REG_AUTO_BIND).set_values(value)


    @property
    def all_roles_allocated(self) -> Optional[bool]:
        """
        Indicates if all required roles have been allocated to devices., 
        """
        return self.register(JD_ROLE_MANAGER_REG_ALL_ROLES_ALLOCATED).bool_value()

    def on_change(self, handler: EventHandlerFn) -> UnsubscribeFn:
        """
        Notifies that role bindings have changed.
        """
        return self.on_event(JD_ROLE_MANAGER_EV_CHANGE, handler)


    def get_role(self, device_id: bytes, service_idx: int) -> None:
        """
        Get the role corresponding to given device identifer. Returns empty string if unset.
        """
        self.send_cmd_packed(JD_ROLE_MANAGER_CMD_GET_ROLE, device_id, service_idx)

    def set_role(self, device_id: bytes, service_idx: int, role: str) -> None:
        """
        Set role. Can set to empty to remove role binding.
        """
        self.send_cmd_packed(JD_ROLE_MANAGER_CMD_SET_ROLE, device_id, service_idx, role)

    def clear_all_roles(self, ) -> None:
        """
        Remove all role bindings.
        """
        self.send_cmd_packed(JD_ROLE_MANAGER_CMD_CLEAR_ALL_ROLES, )
    
