# Autogenerated file. Do not edit.
from jacdac.bus import Bus, Client
from .constants import *
from typing import Optional


class SpeechSynthesisClient(Client):
    """
    A speech synthesizer
    Implements a client for the `Speech synthesis <https://microsoft.github.io/jacdac-docs/services/speechsynthesis>`_ service.
    """

    def __init__(self, bus: Bus, role: str) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_SPEECH_SYNTHESIS, JD_SPEECH_SYNTHESIS_PACK_FORMATS, role)
    

    @property
    def enabled(self) -> Optional[bool]:
        """
        Determines if the speech engine is in a non-paused state., 
        """
        return self.register(JD_SPEECH_SYNTHESIS_REG_ENABLED).bool_value()

    @enabled.setter
    def enabled(self, value: bool) -> None:
        self.register(JD_SPEECH_SYNTHESIS_REG_ENABLED).set_values(value)


    @property
    def lang(self) -> Optional[str]:
        """
        (Optional) Language used for utterances as defined in https://www.ietf.org/rfc/bcp/bcp47.txt., 
        """
        return self.register(JD_SPEECH_SYNTHESIS_REG_LANG).value()

    @lang.setter
    def lang(self, value: str) -> None:
        self.register(JD_SPEECH_SYNTHESIS_REG_LANG).set_values(value)


    @property
    def volume(self) -> Optional[float]:
        """
        (Optional) Volume for utterances., _: /
        """
        return self.register(JD_SPEECH_SYNTHESIS_REG_VOLUME).float_value(100)

    @volume.setter
    def volume(self, value: float) -> None:
        self.register(JD_SPEECH_SYNTHESIS_REG_VOLUME).set_values(value / 100)


    @property
    def pitch(self) -> Optional[float]:
        """
        (Optional) Pitch for utterances, 
        """
        return self.register(JD_SPEECH_SYNTHESIS_REG_PITCH).value()

    @pitch.setter
    def pitch(self, value: float) -> None:
        self.register(JD_SPEECH_SYNTHESIS_REG_PITCH).set_values(value)


    @property
    def rate(self) -> Optional[float]:
        """
        (Optional) Rate for utterances, 
        """
        return self.register(JD_SPEECH_SYNTHESIS_REG_RATE).value()

    @rate.setter
    def rate(self, value: float) -> None:
        self.register(JD_SPEECH_SYNTHESIS_REG_RATE).set_values(value)



    def speak(self, text: str) -> None:
        """
        Adds an utterance to the utterance queue; it will be spoken when any other utterances queued before it have been spoken.
        """
        self.send_cmd_packed(JD_SPEECH_SYNTHESIS_CMD_SPEAK, text)

    def cancel(self, ) -> None:
        """
        Cancels current utterance and all utterances from the utterance queue.
        """
        self.send_cmd_packed(JD_SPEECH_SYNTHESIS_CMD_CANCEL, )
    
