# Autogenerated file. Do not edit.
from jacdac.bus import Bus, Client, EventHandlerFn, UnsubscribeFn
from .constants import *
from typing import Optional


class RelayClient(Client):
    """
    A switching relay.
    Implements a client for the `Relay <https://microsoft.github.io/jacdac-docs/services/relay>`_ service.

    """

    def __init__(self, bus: Bus, role: str) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_RELAY, JD_RELAY_PACK_FORMATS, role)


    @property
    def closed(self) -> Optional[bool]:
        """
        Indicates whether the relay circuit is currently energized (closed) or not., 
        """
        return self.register(JD_RELAY_REG_CLOSED).bool_value()

    @closed.setter
    def closed(self, value: bool) -> None:
        self.register(JD_RELAY_REG_CLOSED).set_values(value)


    @property
    def variant(self) -> Optional[RelayVariant]:
        """
        (Optional) Describes the type of relay used., 
        """
        return self.register(JD_RELAY_REG_VARIANT).value()

    @property
    def max_switching_current(self) -> Optional[int]:
        """
        (Optional) Maximum switching current for a resistive load., _: mA
        """
        return self.register(JD_RELAY_REG_MAX_SWITCHING_CURRENT).value()

    def on_active(self, handler: EventHandlerFn) -> UnsubscribeFn:
        """
        Emitted when relay goes from `inactive` to `active` state.
        Normally open (NO) relays close the circuit when activated.
        """
        return self.on_event(JD_RELAY_EV_ACTIVE, handler)

    def on_inactive(self, handler: EventHandlerFn) -> UnsubscribeFn:
        """
        Emitted when relay goes from `active` to `inactive` state.
        Normally closed (NC) relays open the circuit when activated.
        """
        return self.on_event(JD_RELAY_EV_INACTIVE, handler)

    
