# Autogenerated file. Do not edit.
from jacdac.bus import Bus, Client
from .constants import *
from typing import Optional


class DotMatrixClient(Client):
    """
    A rectangular dot matrix display, made of monochrome LEDs or Braille pins.
    Implements a client for the `Dot Matrix <https://microsoft.github.io/jacdac-docs/services/dotmatrix>`_ service.

    """

    def __init__(self, bus: Bus, role: str) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_DOT_MATRIX, JD_DOT_MATRIX_PACK_FORMATS, role)


    @property
    def dots(self) -> Optional[bytes]:
        """
        The state of the screen where dot on/off state is
        stored as a bit, column by column. The column should be byte aligned., 
        """
        return self.register(JD_DOT_MATRIX_REG_DOTS).value()

    @dots.setter
    def dots(self, value: bytes) -> None:
        self.register(JD_DOT_MATRIX_REG_DOTS).set_values(value)


    @property
    def brightness(self) -> Optional[float]:
        """
        (Optional) Reads the general brightness of the display, brightness for LEDs. `0` when the screen is off., _: /
        """
        return self.register(JD_DOT_MATRIX_REG_BRIGHTNESS).float_value(100)

    @brightness.setter
    def brightness(self, value: float) -> None:
        self.register(JD_DOT_MATRIX_REG_BRIGHTNESS).set_values(value / 100)


    @property
    def rows(self) -> Optional[int]:
        """
        Number of rows on the screen, _: #
        """
        return self.register(JD_DOT_MATRIX_REG_ROWS).value()

    @property
    def columns(self) -> Optional[int]:
        """
        Number of columns on the screen, _: #
        """
        return self.register(JD_DOT_MATRIX_REG_COLUMNS).value()

    @property
    def variant(self) -> Optional[DotMatrixVariant]:
        """
        (Optional) Describes the type of matrix used., 
        """
        return self.register(JD_DOT_MATRIX_REG_VARIANT).value()

    
