# Autogenerated file. Do not edit.
from jacdac.bus import Bus, SensorClient
from .constants import *
from typing import Optional


class HumidityClient(SensorClient):
    """
    A sensor measuring humidity of outside environment.
    Implements a client for the `Humidity <https://microsoft.github.io/jacdac-docs/services/humidity>`_ service.

    """

    def __init__(self, bus: Bus, role: str, *, missing_humidity_value: float = None) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_HUMIDITY, JD_HUMIDITY_PACK_FORMATS, role, preferred_interval = 5000)
        self.missing_humidity_value = missing_humidity_value

    @property
    def humidity(self) -> Optional[float]:
        """
        The relative humidity in percentage of full water saturation., _: %RH
        """
        self.refresh_reading()
        return self.register(JD_HUMIDITY_REG_HUMIDITY).value(self.missing_humidity_value)

    @property
    def humidity_error(self) -> Optional[float]:
        """
        The real humidity is between `humidity - humidity_error` and `humidity + humidity_error`., _: %RH
        """
        return self.register(JD_HUMIDITY_REG_HUMIDITY_ERROR).value()

    @property
    def min_humidity(self) -> Optional[float]:
        """
        Lowest humidity that can be reported., _: %RH
        """
        return self.register(JD_HUMIDITY_REG_MIN_HUMIDITY).value()

    @property
    def max_humidity(self) -> Optional[float]:
        """
        Highest humidity that can be reported., _: %RH
        """
        return self.register(JD_HUMIDITY_REG_MAX_HUMIDITY).value()

    
