# Autogenerated file. Do not edit.
from jacdac.bus import Bus, SensorClient
from .constants import *
from typing import Optional


class FlexClient(SensorClient):
    """
    A bending or deflection sensor.
    Implements a client for the `Flex <https://microsoft.github.io/jacdac-docs/services/flex>`_ service.

    """

    def __init__(self, bus: Bus, role: str, *, missing_bending_value: float = None) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_FLEX, JD_FLEX_PACK_FORMATS, role)
        self.missing_bending_value = missing_bending_value

    @property
    def bending(self) -> Optional[float]:
        """
        The relative position of the slider., _: /
        """
        self.refresh_reading()
        return self.register(JD_FLEX_REG_BENDING).float_value(self.missing_bending_value, 100)

    @property
    def bending_error(self) -> Optional[float]:
        """
        (Optional) Absolute error on the reading value., _: /
        """
        return self.register(JD_FLEX_REG_BENDING_ERROR).float_value(100)

    @property
    def length(self) -> Optional[int]:
        """
        (Optional) Length of the flex sensor, _: mm
        """
        return self.register(JD_FLEX_REG_LENGTH).value()

    
