# Autogenerated file. Do not edit.
from jacdac.bus import Bus, Client, EventHandlerFn, UnsubscribeFn
from .constants import *
from typing import Optional


class HidAdapterClient(Client):
    """
    A service for configuring how Jacdac device map to HID input events. Users can have multiple configurations and swap between them by writing to `current_configuration`.
    Implements a client for the `HID Adapter <https://microsoft.github.io/jacdac-docs/services/hidadapter>`_ service.

    """

    def __init__(self, bus: Bus, role: str) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_HID_ADAPTER, JD_HID_ADAPTER_PACK_FORMATS, role)


    @property
    def num_configurations(self) -> Optional[int]:
        """
        The number of configurations stored on the server., 
        """
        return self.register(JD_HID_ADAPTER_REG_NUM_CONFIGURATIONS).value()

    @num_configurations.setter
    def num_configurations(self, value: int) -> None:
        self.register(JD_HID_ADAPTER_REG_NUM_CONFIGURATIONS).set_values(value)


    @property
    def current_configuration(self) -> Optional[int]:
        """
        The current configuration the server is using., 
        """
        return self.register(JD_HID_ADAPTER_REG_CURRENT_CONFIGURATION).value()

    @current_configuration.setter
    def current_configuration(self, value: int) -> None:
        self.register(JD_HID_ADAPTER_REG_CURRENT_CONFIGURATION).set_values(value)


    def on_changed(self, handler: EventHandlerFn) -> UnsubscribeFn:
        """
        Event that notifies clients that the server has swapped to a new configuration or changed key bindings.
        """
        return self.on_event(JD_HID_ADAPTER_EV_CHANGED, handler)


    def set_binding(self, configuration_number: int, binding_index: int, device_id: int, service_class: int, trigger_value: int, trigger_context: int, service_index: int, selector: int, modifiers: int) -> None:
        """
        Stores the given binding on the server. If a binding exists at this index, the new binding will replace it.
        """
        self.send_cmd_packed(JD_HID_ADAPTER_CMD_SET_BINDING, configuration_number, binding_index, device_id, service_class, trigger_value, trigger_context, service_index, selector, modifiers)

    def clear_binding(self, configuration_number: int, binding_index: int) -> None:
        """
        Clears a specific binding stored on the device.
        """
        self.send_cmd_packed(JD_HID_ADAPTER_CMD_CLEAR_BINDING, configuration_number, binding_index)

    def clear_configuration(self, configuration_number: int) -> None:
        """
        Clears a specific configuration stored on the device.
        """
        self.send_cmd_packed(JD_HID_ADAPTER_CMD_CLEAR_CONFIGURATION, configuration_number)

    def clear(self, ) -> None:
        """
        Clears all configurations and bindings stored on the device.
        """
        self.send_cmd_packed(JD_HID_ADAPTER_CMD_CLEAR, )
    
